<?php 
require_once 'system/db.php';
include 'system/header.php'; 

// Логика удаления сообщения модератором или админом
if (isset($_GET['del_chat']) && isset($_SESSION['level']) && $_SESSION['level'] >= 5) {
    $id = (int)$_GET['del_chat'];
    mysqli_query($db, "DELETE FROM chat WHERE id = $id");
    header("Location: index.php"); exit;
}
?>

<?php
$alert_q = mysqli_query($db, "SELECT * FROM alerts ORDER BY id DESC LIMIT 1");
if($alert = mysqli_fetch_assoc($alert_q)): ?>
    <div class="global-alert">
        📢 <b>Объявление:</b> <?php echo $alert['text']; ?>
    </div>
<?php endif; ?>

<div class="card-title">⚽ Игровой раздел</div>
<div class="game-box" style="background: linear-gradient(135deg, #1b5e20 0%, #4caf50 100%); padding: 15px; border-radius: 15px; color: white; text-align: center; margin-bottom: 20px; box-shadow: 0 4px 15px rgba(0,0,0,0.2);">
    <h3 style="margin: 0 0 10px 0;">Футбольный Менеджер</h3>
    <p style="font-size: 14px; opacity: 0.9;">Создай свой клуб и приведи его к победе!</p>
    <a href="/man/index.php" style="display: inline-block; background: #fff176; color: #1b5e20; padding: 12px 25px; border-radius: 25px; text-decoration: none; font-weight: bold; margin-top: 5px;">Играть сейчас</a>
</div>

<div class="card-title">💬 Живой чат</div>
<div class="chat-preview">
    <?php
    $chat_q = mysqli_query($db, "SELECT chat.*, users.login, users.id as u_id, users.level as u_lvl FROM chat 
                                 JOIN users ON chat.user_id = users.id 
                                 ORDER BY chat.id DESC LIMIT 5");
    while($m = mysqli_fetch_assoc($chat_q)): ?>
        <div class="chat-msg">
            <a href="/users/profile.php?id=<?php echo $m['u_id']; ?>" style="text-decoration:none; font-weight:bold; color: #2e7d32;">
                <?php echo $m['login']; ?> 
            </a>
            <?php if($m['u_lvl'] >= 9) echo "<span style='color:red;font-size:10px;'>[A]</span>"; ?>: 
            <?php echo $m['msg']; ?>
            
            <?php if(isset($_SESSION['level']) && $_SESSION['level'] >= 5): ?>
                <a href="?del_chat=<?php echo $m['id']; ?>" style="color:red; float:right; text-decoration:none; margin-left:10px;">[x]</a>
            <?php endif; ?>
        </div>
    <?php endwhile; ?>
    <a href="/system/chat_page.php" class="btn-more">Открыть чат целиком</a>
</div>

<div class="card-title">📁 Свежие файлы</div>
<div class="file-preview">
    <?php
    $file_q = mysqli_query($db, "SELECT * FROM files ORDER BY id DESC LIMIT 2");
    while($f = mysqli_fetch_assoc($file_q)) {
        echo "<div class='file-card'>📄 <a href='/system/files.php' style='text-decoration:none;color:inherit;'>{$f['filename']}</a></div>";
    }
    ?>
</div>

<?php include 'system/footer.php'; ?>

