<?php
require_once '../system/db.php';
include '../system/header.php';
require_once "manfunc.php"; 

// Проверка прав доступа
if (!isset($_SESSION['level']) || $_SESSION['level'] < 7) {
    header("Location: /"); exit;
}

/**
 * ПРОВЕРКА И СОЗДАНИЕ ТАБЛИЦЫ ПОСТРОЕК
 */
mysqli_query($db, "CREATE TABLE IF NOT EXISTS `fman_build` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `name` varchar(255) NOT NULL,
    `pic` varchar(255) DEFAULT 'nopic.jpg',
    `pay` bigint(20) DEFAULT '0',
    `plus` int(11) DEFAULT '0',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

echo "<div class='fman-container'>";
echo "<div class='card-title' style='text-align:center;'>🏗 Добавление новой постройки</div>";

if (isset($_POST['submit'])) {
    // Обработка данных
    $name = isset($_POST['name']) ? mysqli_real_escape_string($db, trim($_POST['name'])) : false;
    $pic = !empty($_POST['pic']) ? mysqli_real_escape_string($db, trim($_POST['pic'])) : 'nopic.jpg';
    $pay = isset($_POST['pay']) ? abs(intval($_POST['pay'])) : 0;
    $plus = isset($_POST['plus']) ? abs(intval($_POST['plus'])) : 0;

    if (empty($name) || $pay <= 0 || $plus <= 0) {
        echo "<div class='note-item' style='border-left-color:var(--danger); color:var(--danger);'>
                <b>Ошибка:</b> Нужно указать название, стоимость и доход!
              </div>";
    } else {
        $res = mysqli_query($db, "INSERT INTO `fman_build` SET 
            `name` = '$name', 
            `pic` = '$pic', 
            `plus` = '$plus', 
            `pay` = '$pay'");
            
        if ($res) {
            echo "<div class='note-item' style='border-left-color:var(--success); color:var(--success);'>
                    ✅ Постройка <b>$name</b> успешно добавлена в базу!
                  </div>";
        } else {
            echo "<div class='note-item' style='border-left-color:var(--danger);'>Ошибка базы данных!</div>";
        }
    }
}

// Форма добавления
echo "<div class='exchange-form' style='background:#f9f9f9; padding:15px; border-radius:12px; border:1px solid #eee;'>
    <form action='addbuild.php' method='post'>
        <div style='margin-bottom:10px;'>
            <label style='font-size:12px; color:#666;'>Название здания:</label><br/>
            <input type='text' name='name' placeholder='Напр: Тренировочная база' style='width:100%; padding:10px; border-radius:5px; border:1px solid #ccc;'>
        </div>
        
        <div style='margin-bottom:10px;'>
            <label style='font-size:12px; color:#666;'>Имя файла картинки:</label><br/>
            <input type='text' name='pic' value='nopic.jpg' style='width:100%; padding:10px; border-radius:5px; border:1px solid #ccc;'>
        </div>

        <div style='display: grid; grid-template-columns: 1fr 1fr; gap: 10px; margin-bottom:15px;'>
            <div>
                <label style='font-size:12px; color:#666;'>Цена ($):</label><br/>
                <input type='number' name='pay' placeholder='100000' style='width:100%; padding:10px; border-radius:5px; border:1px solid #ccc;'>
            </div>
            <div>
                <label style='font-size:12px; color:#666;'>Доход в день ($):</label><br/>
                <input type='number' name='plus' placeholder='5000' style='width:100%; padding:10px; border-radius:5px; border:1px solid #ccc;'>
            </div>
        </div>

        <button type='submit' name='submit' value='1' style='background:var(--success); color:white; border:none; padding:12px; width:100%; border-radius:8px; font-weight:bold; cursor:pointer;'>
            🚀 Создать постройку
        </button>
    </form>
</div>";

echo "<div style='text-align:center; margin-top:20px;'>
    <a href='adminka.php' class='btn-land' style='background:#eee; color:#333; text-decoration:none; padding:8px 15px; border-radius:5px;'>⬅ Назад в админку</a>
</div>";

echo "</div>";

include '../system/footer.php';
?>

