<?php
require_once '../system/db.php';
include '../system/header.php';

// Проверка авторизации без использования сторонних функций


// Получаем актуальные данные пользователя и клуба
$user_data_q = mysqli_query($db, "SELECT * FROM `users` WHERE `id` = '$user_id' LIMIT 1");
$user_data = mysqli_fetch_assoc($user_data_q);

$club_q = mysqli_query($db, "SELECT `id`, `budj` FROM `fman_clubs` WHERE `user_id` = '$user_id' LIMIT 1");
$club_data = mysqli_fetch_assoc($club_q);

$action = isset($_GET['action']) ? htmlspecialchars($_GET['action']) : '';

echo "<style>
    .bank-card { background: #fff; border-radius: 15px; padding: 20px; margin-bottom: 20px; box-shadow: 0 4px 15px rgba(0,0,0,0.05); border-left: 5px solid #3498db; }
    .currency-val { font-size: 18px; font-weight: bold; color: #2c3e50; }
    .exchange-form { background: #f9f9f9; padding: 15px; border-radius: 10px; border: 1px solid #eee; }
    .input-exchange { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 8px; margin-bottom: 10px; font-size: 16px; box-sizing: border-box; }
    .btn-exchange { background: #27ae60; color: #fff; border: none; padding: 12px; border-radius: 8px; cursor: pointer; font-weight: bold; width: 100%; transition: 0.3s; }
    .btn-exchange:hover { opacity: 0.9; }
</style>";

echo "<div class='card-title'>💰 Финансовый департамент</div>";

// Информация о счетах
echo "<div class='bank-card'>
        <div style='display: flex; justify-content: space-around;'>
            <div style='text-align: center;'>
                <div style='font-size: 12px; color: #7f8c8d;'>Баллы сайта</div>
                <div class='currency-val'>⭐ " . number_format($user_data['balans'], 0, '.', ' ') . "</div>
            </div>
            <div style='text-align: center;'>
                <div style='font-size: 12px; color: #7f8c8d;'>Бюджет клуба</div>
                <div class='currency-val'>$ " . number_format($club_data['budj'] ?? 0, 0, '.', ' ') . "</div>
            </div>
        </div>
      </div>";

// Обработка действий
if ($action == 'change') {
    $num = isset($_POST['num']) ? intval($_POST['num']) : 0;
    if ($num < 1) {
        echo "<div style='color:red; text-align:center; padding:10px;'>Введите число!</div>";
    } elseif ($user_data['balans'] < $num) {
        echo "<div style='color:red; text-align:center; padding:10px;'>Недостаточно баллов!</div>";
    } else {
        $baks = $num * 1000;
        mysqli_query($db, "UPDATE `users` SET `balans` = `balans` - $num WHERE `id` = '$user_id'");
        mysqli_query($db, "UPDATE `fman_clubs` SET `budj` = `budj` + $baks WHERE `user_id` = '$user_id'");
        echo "<div style='background:#e8f5e9; color:#2e7d32; padding:15px; border-radius:10px; margin:10px; text-align:center;'>✅ Обмен завершен! Бюджет пополнен на $".number_format($baks)."</div>";
        echo "<meta http-equiv='refresh' content='2; url=bank.php'>";
    }
}

if ($action == 'change1') {
    $num = isset($_POST['num']) ? intval($_POST['num']) : 0;
    if ($num < 2000) {
        echo "<div style='color:red; text-align:center; padding:10px;'>Минимум $2 000!</div>";
    } elseif ($club_data['budj'] < $num) {
        echo "<div style='color:red; text-align:center; padding:10px;'>Недостаточно денег в клубе!</div>";
    } else {
        $balls = floor($num / 2000);
        $spent = $balls * 2000;
        mysqli_query($db, "UPDATE `users` SET `balans` = `balans` + $balls WHERE `id` = '$user_id'");
        mysqli_query($db, "UPDATE `fman_clubs` SET `budj` = `budj` - $spent WHERE `user_id` = '$user_id'");
        echo "<div style='background:#e8f5e9; color:#2e7d32; padding:15px; border-radius:10px; margin:10px; text-align:center;'>✅ Обмен завершен! Вы получили $balls баллов.</div>";
        echo "<meta http-equiv='refresh' content='2; url=bank.php'>";
    }
}

// Формы обмена
if (!$club_data) {
    echo "<div class='note-item' style='border-left-color:red;'>У вас еще нет футбольного клуба для проведения операций.</div>";
} else {
    echo "<div style='display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 20px; padding: 10px;'>";

    // Покупка денег клуба
    echo "<div class='exchange-form'>
            <div style='font-weight: bold; margin-bottom: 10px;'>⭐ Пополнить бюджет</div>
            <form action='bank.php?action=change' method='post'>
                <input name='num' type='number' class='input-exchange' placeholder='Количество баллов...' min='1' required>
                <button type='submit' class='btn-exchange'>Получить игровые $</button>
                <div style='font-size: 11px; color: #95a5a6; margin-top: 5px; text-align: center;'>Курс: 1 балл = 1 000$</div>
            </form>
          </div>";

    // Покупка баллов сайта
    echo "<div class='exchange-form'>
            <div style='font-weight: bold; margin-bottom: 10px;'>💵 Вывести в баллы</div>
            <form action='bank.php?action=change1' method='post'>
                <input name='num' type='number' class='input-exchange' placeholder='Сумма в $...' min='2000' step='2000' required>
                <button type='submit' class='btn-exchange' style='background: #34495e;'>Получить баллы сайта</button>
                <div style='font-size: 11px; color: #95a5a6; margin-top: 5px; text-align: center;'>Курс: 2 000$ = 1 балл</div>
            </form>
          </div>";

    echo "</div>";
}

echo "<div style='text-align:center; margin-top:30px;'>
        <a href='index.php' style='text-decoration:none; color:#7f8c8d; font-size:14px;'>⬅ Вернуться в менеджер</a>
      </div>";

include '../system/footer.php';
?>

