<?php
require_once '../system/db.php';
include '../system/header.php';

// Проверка прав администратора (минимум 1 уровень по вашей системе)


$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Получаем данные клуба
$q = mysqli_query($db, "SELECT * FROM fman_clubs WHERE id = '$id' LIMIT 1");
$a = mysqli_fetch_assoc($q);

if (!$a) {
    echo "<div class='note-item'>Клуб не найден.</div>";
    include '../system/footer.php'; exit;
}

?>

<style>
    .admin-card {
        background: #fff; border-radius: 15px; padding: 20px;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1); margin: 10px;
        border-top: 5px solid #f39c12;
    }
    .input-label { display: block; margin-bottom: 8px; font-size: 14px; color: #7f8c8d; font-weight: bold; }
    .input-budj { 
        width: 100%; padding: 12px; border: 2px solid #ecf0f1; 
        border-radius: 8px; font-size: 18px; font-weight: bold; 
        color: #2c3e50; margin-bottom: 20px; box-sizing: border-box;
    }
    .input-budj:focus { border-color: #f39c12; outline: none; }
    .btn-save { 
        background: #f39c12; color: white; border: none; 
        width: 100%; padding: 15px; border-radius: 8px; 
        font-weight: bold; cursor: pointer; transition: 0.3s;
    }
    .btn-save:hover { background: #e67e22; }
    .current-val { background: #fdf9f2; padding: 10px; border-radius: 8px; margin-bottom: 15px; font-size: 13px; }
</style>

<div class="admin-card">
    <h2 align="center" style="margin-top:0;">💰 Изменение бюджета</h2>
    <p align="center" style="color:#7f8c8d;">Клуб: <b><?php echo htmlspecialchars($a['name']); ?></b></p>

    <?php
    if (isset($_POST['submit'])) {
        $new_budj = (int)$_POST['budj'];
        
        // Логируем изменение (по желанию можно добавить в таблицу логов)
        mysqli_query($db, "UPDATE fman_clubs SET budj = '$new_budj' WHERE id = '$id' LIMIT 1");
        
        echo "<div class='note-item' style='border-left: 4px solid #27ae60; background: #f0fdf4; color: #27ae60; margin-bottom: 20px;'>
                ✅ Изменения успешно сохранены!
              </div>";
        
        // Обновляем данные для отображения в форме
        $a['budj'] = $new_budj;
    }
    ?>

    <form action="budj.php?id=<?php echo $id; ?>" method="post">
        <div class="current-val">
            Текущее состояние: <b>$<?php echo number_format($a['budj'], 0, '.', ' '); ?></b>
        </div>
        
        <label class="input-label">Введите новую сумму:</label>
        <input type="number" name="budj" value="<?php echo $a['budj']; ?>" class="input-budj" required>
        
        <input type="submit" name="submit" value="ОБНОВИТЬ БАДЖЕТ" class="btn-save">
    </form>
</div>



<div style="text-align:center; margin-top:20px;">
    <a href="club.php?id=<?php echo $id; ?>" style="text-decoration:none; color:#3498db; font-weight:bold;">⬅ Назад в клуб</a><br><br>
    <a href="index.php" style="text-decoration:none; color:#7f8c8d;">Панель управления</a>
</div>

<?php include '../system/footer.php'; ?>

