<?php
require_once '../system/db.php';
include '../system/header.php';

// 1. ПОЛУЧАЕМ ID КЛУБА ТЕКУЩЕГО ПОЛЬЗОВАТЕЛЯ
$my_id = isset($_SESSION['user_id']) ? intval($_SESSION['user_id']) : 0;
$club_res = mysqli_query($db, "SELECT * FROM `fman_clubs` WHERE `user_id` = '$my_id' LIMIT 1");
$dataclub = mysqli_fetch_assoc($club_res);
$club_id = $dataclub['id'] ?? 0; // Если клуба нет, будет 0

// CSS для оформления зданий (без изменений)
?>
<style>
    .build-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(280px, 1fr)); gap: 15px; padding: 10px; }
    .build-card { background: #fff; border-radius: 12px; overflow: hidden; box-shadow: 0 4px 10px rgba(0,0,0,0.05); border: 1px solid #eee; display: flex; flex-direction: column; }
    .build-img { width: 100%; height: 120px; object-fit: cover; background: #f0f0f0; }
    .build-body { padding: 15px; flex-grow: 1; }
    .build-name { font-size: 16px; font-weight: bold; color: #2c3e50; margin-bottom: 5px; }
    .build-stats { font-size: 13px; color: #7f8c8d; margin-bottom: 10px; }
    .stat-val { color: #27ae60; font-weight: bold; }
    .build-footer { padding: 10px 15px; background: #f9f9f9; border-top: 1px solid #eee; display: flex; justify-content: space-between; align-items: center; }
    .btn-build { background: #3498db; color: #fff; border: none; padding: 8px 15px; border-radius: 6px; cursor: pointer; text-decoration: none; font-size: 13px; font-weight: bold; }
    .owned-badge { background: #ebfbee; color: #2f9e44; padding: 4px 10px; border-radius: 20px; font-size: 11px; font-weight: bold; }
</style>



<?php
// Проверка на наличие клуба только для действий покупки или управления своим клубом
$view_club = isset($_GET['club']) ? intval($_GET['club']) : 0;

if (!$club_id && $view_club == 0) {
    echo "<div class='note-item' style='border-left: 4px solid #e74c3c; background: #fff5f5; padding: 20px;'>
            <b>Внимание!</b><br>Для управления инфраструктурой вам необходимо иметь собственный клуб!
          </div>";
} else {
    $new = isset($_GET['new']) ? intval($_GET['new']) : 0;

    // --- ЛОГИКА ПОКУПКИ ---
    if ($new > 0) {
        $sql = mysqli_query($db, "SELECT * FROM `fman_build` WHERE `id`='$new' LIMIT 1");
        $b = mysqli_fetch_assoc($sql);

        if (!$b) {
            echo "<div class='note-item' style='border-left: 4px solid #e74c3c;'>Такой постройки не существует!</div>";
        } else {
            $check = mysqli_query($db, "SELECT id FROM `fman_clubs_build` WHERE `bid`='$new' AND `club_id`='$club_id' LIMIT 1");
            if (mysqli_num_rows($check) > 0) {
                echo "<div class='note-item' style='border-left: 4px solid #f39c12;'>Это здание уже возведено на вашей территории!</div>";
            } elseif ($b['pay'] > $dataclub['budj']) {
                echo "<div class='note-item' style='border-left: 4px solid #e74c3c;'>Недостаточно средств. Вам нужно еще $" . number_format($b['pay'] - $dataclub['budj']) . "</div>";
            } else {
                mysqli_query($db, "INSERT INTO `fman_clubs_build` (`club_id`, `bid`) VALUES ('$club_id', '$new')");
                mysqli_query($db, "UPDATE `fman_clubs` SET `budj`=`budj`-'$b[pay]', `plus`=`plus`+'$b[plus]' WHERE `id`='$club_id' LIMIT 1");
                echo "<div class='note-item' style='border-left: 4px solid #27ae60;'>Поздравляем! Постройка <b>{$b['name']}</b> завершена. Доход клуба увеличен.</div>";
            }
        }
        echo "<div class='menu-item' style='text-align:center;'><a href='build.php'>Вернуться к списку</a></div>";

    // --- ПРОСМОТР ЧУЖОГО КЛУБА ---
    } elseif ($view_club > 0) {
        $q_club = mysqli_query($db, "SELECT name FROM `fman_clubs` WHERE `id`='$view_club' LIMIT 1");
        if (mysqli_num_rows($q_club) > 0) {
            $dc = mysqli_fetch_assoc($q_club);
            echo "<div class='card-title'>Инфраструктура клуба: " . htmlspecialchars($dc['name']) . "</div>";
            $sql = mysqli_query($db, "SELECT b.* FROM `fman_clubs_build` cb LEFT JOIN `fman_build` b ON b.id = cb.bid WHERE cb.club_id = '$view_club'");
            
            if (mysqli_num_rows($sql) > 0) {
                echo "<div class='build-grid'>";
                while ($b = mysqli_fetch_assoc($sql)) {
                    echo "<div class='build-card'>
                            <div class='build-body'>
                                <div class='build-name'>{$b['name']}</div>
                                <div class='build-stats'>Приносит доход: <span class='stat-val'>$" . number_format($b['plus']) . "</span>/нед.</div>
                            </div>
                          </div>";
                }
                echo "</div>";
            } else { echo "<div class='note-item'>У данного клуба пока нет построек.</div>"; }
        }

    // --- ГЛАВНАЯ СТРАНИЦА ПОСТРОЕК (СВОЯ) ---
    } else {
        // Доступные для покупки
        echo "<div class='card-title'>🏗️ Доступные проекты (Бюджет: $" . number_format($dataclub['budj']) . ")</div>";
        $sql = mysqli_query($db, "SELECT * FROM `fman_build` WHERE id NOT IN (SELECT bid FROM fman_clubs_build WHERE club_id = '$club_id')");
        
        if (mysqli_num_rows($sql) > 0) {
            echo "<div class='build-grid'>";
            while ($b = mysqli_fetch_assoc($sql)) {
                echo "<div class='build-card'>
                        <div class='build-body'>
                            <div class='build-name'>{$b['name']}</div>
                            <div class='build-stats'>
                                Цена: <b>$" . number_format($b['pay']) . "</b><br>
                                Доход: <span class='stat-val'>+$" . number_format($b['plus']) . " / нед.</span>
                            </div>
                        </div>
                        <div class='build-footer'>
                            <a href='build.php?new={$b['id']}' class='btn-build'>Построить</a>
                        </div>
                      </div>";
            }
            echo "</div>";
        } else { echo "<div class='note-item'>Вы реализовали все доступные проекты!</div>"; }

        // Уже имеющиеся
        echo "<div class='card-title'>🏘️ Моя территория</div>";
        $sql = mysqli_query($db, "SELECT b.* FROM `fman_clubs_build` cb LEFT JOIN `fman_build` b ON b.id = cb.bid WHERE cb.club_id = '$club_id'");
        
        if (mysqli_num_rows($sql) > 0) {
            echo "<div class='build-grid'>";
            while ($b = mysqli_fetch_assoc($sql)) {
                echo "<div class='build-card' style='opacity: 0.9;'>
                        <div class='build-body'>
                            <div class='build-name'>{$b['name']}</div>
                            <div class='build-stats'>Еженедельный доход: <span class='stat-val'>$" . number_format($b['plus']) . "</span></div>
                        </div>
                        <div class='build-footer'>
                            <span class='owned-badge'>Построено</span>
                        </div>
                      </div>";
            }
            echo "</div>";
        }
    }
}

echo "<div class='footer-nav' style='text-align:center; margin-top:20px;'>
        <a href='index.php' class='btn-land' style='background:#f1f2f6; padding: 10px 20px; border-radius: 8px; text-decoration: none; color: #333;'>⬅ В менеджер</a>
      </div>";

include '../system/footer.php';
?>

