<?php
require_once '../system/db.php';
include '../system/header.php';
require_once "manfunc.php"; 

// --- НАСТРОЙКИ ---
$my_id = isset($_SESSION['user_id']) ? (int)$_SESSION['user_id'] : 0;
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($my_id && !$id) {
    $res_my_club = mysqli_query($db, "SELECT id FROM fman_clubs WHERE user_id = $my_id LIMIT 1");
    $my_club_data = mysqli_fetch_assoc($res_my_club);
    $id = $my_club_data['id'] ?? 0;
}

// Загрузка данных клуба
$qt = mysqli_query($db, "SELECT * FROM fman_clubs WHERE id = $id LIMIT 1");
$tdata = mysqli_fetch_assoc($qt);

// Если залогиненный юзер смотрит свой клуб, подгружаем его полные данные (для лимитов транса/увола)
$dataclub = ($my_id && $tdata['user_id'] == $my_id) ? $tdata : null;

$pid = isset($_GET['pid']) ? (int)$_GET['pid'] : 0;
$act = isset($_GET['act']) ? mysqli_real_escape_string($db, $_GET['act']) : '';

if ($pid) {
    $qp = mysqli_query($db, "SELECT * FROM fman_players WHERE id = $pid LIMIT 1");
    $pdata = mysqli_fetch_assoc($qp);
}

// Массив амплуа
$roles = array(1 => 'ВР', 2 => 'ЛЗ', 3 => 'ЦЗ', 4 => 'ПЗ', 5 => 'ОП', 6 => 'ЛП', 7 => 'ЦП', 8 => 'ПП', 9 => 'АП', 10 => 'Н');

?>

<style>
    .player-card {
        background: white; border-radius: 12px; padding: 12px; margin-bottom: 10px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08); border-left: 4px solid #3498db;
    }
    .player-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 8px; }
    .player-name { font-weight: bold; color: #2c3e50; text-decoration: none; font-size: 15px; }
    .player-role { background: #f1f2f6; padding: 2px 8px; border-radius: 6px; font-size: 11px; font-weight: bold; color: #7f8c8d; }
    .stats-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 5px; font-size: 11px; color: #636e72; background: #fafafa; padding: 8px; border-radius: 8px; }
    .stat-item b { color: #2d3436; }
    .player-actions { margin-top: 10px; display: flex; gap: 8px; flex-wrap: wrap; }
    .btn-small { font-size: 10px; padding: 5px 10px; border-radius: 5px; text-decoration: none; font-weight: bold; }
    .btn-uvol { background: #fff0f0; color: #e74c3c; border: 1px solid #fab1a0; }
    .btn-trans { background: #f0f7ff; color: #3498db; border: 1px solid #74b9ff; }
    .on-trans { background: #ffeaa7; color: #d63031; padding: 2px 6px; border-radius: 4px; font-size: 10px; font-weight: bold; }
</style>

<div style="padding: 10px;">

<?php
switch ($act) {
    default:
        echo "<h2 align='center'>Состав клуба " . htmlspecialchars($tdata['name']) . "</h2>";
        
        $q = mysqli_query($db, "SELECT * FROM fman_players WHERE team_id = $id ORDER BY ampl ASC, rait DESC");
        
        if (mysqli_num_rows($q) > 0) {
            while ($a = mysqli_fetch_assoc($q)) {
                echo "<div class='player-card'>";
                echo "<div class='player-header'>";
                echo "<div><a href='player.php?id={$a['id']}' class='player-name'>{$a['name']}</a>";
                if ($a['trans']) echo " <span class='on-trans'>TRANS</span>";
                echo "</div>";
                echo "<span class='player-role'>" . $roles[$a['ampl']] . "</span>";
                echo "</div>";

                echo "<div class='stats-grid'>
                    <div class='stat-item'>Талант: <b>" . ($a['rait']) . "</b></div>
                    <div class='stat-item'>Опыт: <b>{$a['ball']}</b></div>
                    <div class='stat-item'>Форма: <b>" . ($a['forma'] / 10) . "</b></div>
                    <div class='stat-item'>Скор: <b>{$a['u']}</b></div>
                    <div class='stat-item'>Пас: <b>{$a['pas']}</b></div>
                    <div class='stat-item'>Удар: <b>{$a['toch']}</b></div>
                </div>";

                if ($dataclub) { // Если это мой клуб, выводим кнопки управления
                    echo "<div class='player-actions'>";
                    if ($a['trans']) {
                        echo "<a href='list-of-players.php?id=$id&pid={$a['id']}&act=atrans' class='btn-small btn-trans'>Снять с трансфера</a>";
                    } else {
                        echo "<a href='list-of-players.php?id=$id&pid={$a['id']}&act=trans' class='btn-small btn-trans'>На трансфер</a>";
                        echo "<a href='list-of-players.php?id=$id&pid={$a['id']}&act=uvol' class='btn-small btn-uvol'>Уволить</a>";
                    }
                    echo "</div>";
                }
                echo "</div>";
            }
            echo "<div class='info-card' style='text-align:center; padding:10px;'>Всего игроков: <b>" . mysqli_num_rows($q) . "</b></div>";
        } else {
            echo "<div class='note-item'>В составе пока нет игроков. Обновление произойдет скоро.</div>";
        }
        break;

    case 'uvol':
        echo "<h3 align='center'>Увольнение игрока</h3>";
        $e = false;
        if ($pdata['trans']) $e = "Ошибка! Сначала снимите игрока с трансфера.";
        if (function_exists('count_players') && count_players($id) < 19) $e = "Ошибка! В команде должно оставаться минимум 19 игроков.";
        if ($dataclub['uvol_count'] >= 1) $e = "Ошибка! Лимит: 1 увольнение в неделю.";

        if ($e) {
            echo "<div class='note-item' style='border-left:4px solid var(--danger);'>$e</div>";
            echo "<a href='list-of-players.php?id=$id' class='btn-small btn-trans'>Назад</a>";
        } else {
            if (!isset($_GET['yes'])) {
                echo "<div class='confirm-box' style='background:white; padding:20px; border-radius:15px; text-align:center;'>
                        Вы уверены, что хотите уволить <b>{$pdata['name']}</b>?<br>
                        Сумма компенсации: <b style='color:red;'>$500 000</b><br><br>
                        <a href='list-of-players.php?id=$id&pid=$pid&act=uvol&yes=yes' class='btn-action btn-yes'>Подтвердить</a>
                        <a href='list-of-players.php?id=$id' class='btn-action btn-no'>Отмена</a>
                      </div>";
            } else {
                $realtime = time();
                mysqli_query($db, "UPDATE `fman_players` SET `team_id`='0', `trans`='1', `cena`='0', `zarplat`='0', `trans_time`='" . (($realtime + 259200)) . "' WHERE `id`='$pid'");
                $new_budj = $dataclub['budj'] - 500000;
                $new_uvol_count = $dataclub['uvol_count'] + 1;
                mysqli_query($db, "UPDATE fman_clubs SET budj=$new_budj, uvol_count=$new_uvol_count WHERE id=$id");
                
                if(function_exists('zamena')) zamena($tdata, $pdata);
                
                $wtext = mysqli_real_escape_string($db, "Игрок {$pdata['name']} был уволен. Выплачены отступные $500 000.");
                mysqli_query($db, "INSERT INTO fman_news (time, club_id, text) VALUES ($realtime, $id, '$wtext')");
                
                echo "<div class='note-item' style='border-left:4px solid var(--success);'>Игрок успешно уволен.</div>";
                echo "<a href='list-of-players.php?id=$id' class='btn-small btn-trans'>К списку</a>";
            }
        }
        break;

    case 'trans':
        // Проверка открытости трансферного окна
        $gconf_res = mysqli_query($db, "SELECT `open` FROM `manager` LIMIT 1");
        $gconf = mysqli_fetch_assoc($gconf_res);

        if ($gconf['open'] != 1) {
            echo "<h3 align='center'>Выход на трансфер</h3>";
            if ($dataclub['trans_count'] >= 2) {
                echo "<div class='note-item'>Лимит: не более 2 игроков в неделю.</div>";
            } else {
                if (!isset($_POST['submit'])) {
                    echo "<div class='confirm-box' style='background:white; padding:20px; border-radius:15px;'>
                            <form action='list-of-players.php?id=$id&pid=$pid&act=trans' method='post'>
                                Выставляем игрока <b>{$pdata['name']}</b><br><br>
                                Укажите цену ($):<br>
                                <input type='number' name='cena' value='1000000' style='width:100%; padding:10px; margin:10px 0; border:1px solid #ddd; border-radius:8px;'><br>
                                <input type='submit' name='submit' value='Выставить' class='btn-action btn-yes' style='border:none; width:100%;'>
                            </form>
                          </div>";
                } else {
                    $cena = (int)$_POST['cena'];
                    if ($cena < 0) $cena = 0;
                    $realtime = time();
                    mysqli_query($db, "UPDATE `fman_players` SET `trans`='1', `cena`='$cena', `zarplat`='0', `trans_time`='" . ($realtime + 259200) . "' WHERE `id`='$pid'");
                    $new_trans_count = $dataclub['trans_count'] + 1;
                    mysqli_query($db, "UPDATE fman_clubs SET trans_count=$new_trans_count WHERE id=$id");
                    
                    echo "<div class='note-item' style='border-left:4px solid var(--success);'>Игрок выставлен на продажу за $" . number_format($cena) . "</div>";
                    echo "<a href='list-of-players.php?id=$id' class='btn-small btn-trans'>Назад</a>";
                }
            }
        } else {
            echo "<div class='note-item'>Трансферное окно закрыто администрацией!</div>";
        }
        break;

    case 'atrans':
        mysqli_query($db, "UPDATE `fman_players` SET `trans`='0', `cena`='0' WHERE `id`='$pid'");
        echo "<div class='note-item' style='border-left:4px solid var(--success);'>Игрок <b>{$pdata['name']}</b> снят с трансфера.</div>";
        echo "<a href='list-of-players.php?id=$id' class='btn-small btn-trans'>Назад</a>";
        break;
}
?>

</div>

<div class="card-title" style="text-align:center; margin-top:20px;">
    <a href="club.php?id=<?php echo $id; ?>" style="text-decoration:none; color:#7f8c8d;">⬅ К управлению клубом</a>
</div>

<?php include '../system/footer.php'; ?>

