<?php
global $db; 

// Устанавливаем часовой пояс МСК, чтобы всё (трансферы, матчи, выплаты) работало по одному времени
date_default_timezone_set('Europe/Moscow');

$realtime = time();
$trans = 1;
require_once 'ab.php';

/**
 * Функция получения данных о стране/лиге
 */
function land($land, $type)
{
    global $db;
    $land = mysqli_real_escape_string($db, $land);
    $q = mysqli_query($db, "SELECT * FROM `fman_lands` WHERE `code` = '$land' LIMIT 1;");
    
    if ($q && mysqli_num_rows($q) > 0) {
        $a = mysqli_fetch_array($q);
        if ($type == 'im') {
            $type = 'name';
        } elseif ($type == 'link') {
            return '<a href="index.php?act=' . $land . '"><img src="flags_icon/' . $land . '.png" alt="' . $land . '"/> ' . $a['name'] . '</a>';
        }
        return isset($a[$type]) ? $a[$type] : '';
    }
    return '';
}

/**
 * Подсчет игроков в команде
 */
function count_players($id)
{
    global $db;
    $id = intval($id);
    $res = mysqli_query($db, "SELECT COUNT(*) FROM `fman_players` WHERE `team_id` = $id");
    if ($res) {
        $row = mysqli_fetch_row($res);
        return $row[0];
    }
    return 0;
}

/**
 * Добавление новости
 */
function newsadd($text, $id)
{
    global $db;
    $text = mysqli_real_escape_string($db, $text);
    $id = intval($id);
    mysqli_query($db, "INSERT INTO `fman_news` SET `time`='" . time() . "', `pl_id`='0', `text`='$text', `club_id`='$id'");
}

/**
 * Определение названия турнира
 */
function turn($turn, $tur, $land)
{
    $r = '';
    if ($turn == "sc") $r = "Суперкубок УЕФА";
    if ($turn == "lc") $r = "Лига Чемпионов";
    if ($turn == "le") $r = "Лига Европы";
    
    if (($turn == "le" || $turn == "lc") && $tur) {
        if ($land != "eu") {
            $r1 = strtr($tur, array(116 => '1/16 финала', 18 => '1/8 финала', 14 => '1/4 финала', 12 => '1/2 финала', 11 => 'Финал'));
            $r .= ". " . strtr($r1, array('а1' => 'а. Первый матч', 'а2' => 'а. Ответный матч'));
        } else {
            $grp = strtr($tur, array('a' => 'A', 'b' => 'B', 'c' => 'C', 'd' => 'D', 'e' => 'E', 'f' => 'F', 'g' => 'G', 'h' => 'H', 'i' => 'I', 'j' => 'J', 'k' => 'K', 'l' => 'L'));
            $r .= ". Группа $grp. $tur тур";
        }
    }
    
    if ($turn == "cup") {
        $r = "Кубок " . land($land, 'rod');
        if ($tur) $r .= ". " . strtr($tur, array(1 => 'Квалифицированный раунд', 18 => '1/8 финала', 14 => '1/4 финала', 12 => '1/2 финала', 11 => 'Финал'));
    }
    
    if ($turn == "supercup") $r = "Суперкубок " . land($land, 'rod');
    if ($turn == "champ") {
        $r = "Чемпионат " . land($land, 'rod') . ". " . land($land, 'lig');
        if ($tur) $r .= ". $tur тур";
    }
    if ($turn == "tm") $r = "Товарищеский матч";
    return $r;
}

/**
 * Вывод плашки матча
 */
function match($a, $id, $sub)
{
    global $realtime;
    if (!$id) $id = 'no_id';
    echo "<div class='menu'>" . date("d.m / H:i", $a['time']) . "<br/>";
    
    if ($a['id1'] != $id) echo "<a href='club.php?id=$a[id1]'>$a[kom1]</a> - "; else echo "<b>$a[kom1]</b> - ";
    if ($a['id2'] != $id) echo "<a href='club.php?id=$a[id2]'>$a[kom2]</a>"; else echo "<b>$a[kom2]</b>";
    
    if ($a['end'] == 1 || $realtime > $a['time']) {
        echo " <a href='match.php?id=$a[id]'><b>$a[sc1]:$a[sc2]</b></a>";
    } else {
        echo " vs ";
    }
    
    if ($sub) echo "<div class='sub'>$sub</div>";
    echo "</div>";
}

/**
 * Текстовое описание навыка
 */
function navyk($var) {
    if ($var == 0) return "отсутствует";
    $skills = array(
        1 => "катастрофично", 2 => "ужасно", 3 => "плохо", 4 => "слабо", 5 => "недостаточно",
        6 => "сносно", 7 => "хорошо", 8 => "отлично", 9 => "превосходно", 10 => "восхитительно",
        11 => "блестяще", 12 => "потрясающе", 13 => "мирового класса", 14 => "сверхъестественно",
        15 => "колоссально", 16 => "запредельно", 17 => "сказочно", 18 => "волшебно", 19 => "легендарно"
    );
    return ($var > 19) ? "божественно" : $skills[$var];
}

/**
 * Автоматическая замена игрока
 */
function zamena($m, $pl)
{
    global $db;
    $hu = ($pl['pos'] != 1) ? "pos!=1" : "pos=1";
    $q = mysqli_query($db, "SELECT id FROM fman_players WHERE id NOT IN ({$m['p1']},{$m['p2']},{$m['p3']},{$m['p4']},{$m['p5']},{$m['p6']},{$m['p7']},{$m['p8']},{$m['p9']},{$m['p10']},{$m['p11']}) AND team_id={$m['id']} AND $hu ORDER BY rait DESC LIMIT 1;");
    
    if ($q && mysqli_num_rows($q) == 0) {
        $q = mysqli_query($db, "SELECT id FROM fman_players WHERE id NOT IN ({$m['p1']},{$m['p2']},{$m['p3']},{$m['p4']},{$m['p5']},{$m['p6']},{$m['p7']},{$m['p8']},{$m['p9']},{$m['p10']},{$m['p11']}) AND team_id={$m['id']} ORDER BY rait DESC LIMIT 1;");
    }
    
    if ($q && $a = mysqli_fetch_assoc($q)) {
        $pos_key = '';
        for ($i = 1; $i <= 11; $i++) {
            if ($m['p' . $i] == $pl['id']) { $pos_key = 'p' . $i; break; }
        }
        if ($pos_key) mysqli_query($db, "UPDATE fman_clubs SET $pos_key={$a['id']} WHERE id={$m['id']}");
    }
}

// --- ОСНОВНОЙ БЛОК ОБРАБОТКИ ---

// Получение данных клуба текущего юзера
$club_id = false;
$dataclub = false;
if (!empty($user_id)) {
    $qka = mysqli_query($db, "SELECT * FROM `fman_clubs` WHERE `user_id`='$user_id' LIMIT 1;");
    if ($qka && mysqli_num_rows($qka) > 0) {
        $dataclub = mysqli_fetch_assoc($qka);
        $club_id = $dataclub['id'];
        // Проверка на активность клуба (условие u9)
        if ($dataclub['u9'] < 1) {
            $club_id = false;
            $dataclub = false;
        }
    }
}

// --- ИСПРАВЛЕННЫЙ ЗАПУСК СИМУЛЯЦИИ МАТЧЕЙ ---
// Ищем все матчи, время которых наступило (или прошло), но они не завершены
$qam = mysqli_query($db, "SELECT `id`, `id1`, `id2` FROM `fman_matches` WHERE `time` <= $realtime AND `end` = 0;");
if ($qam && mysqli_num_rows($qam) > 0) {
    while ($m = mysqli_fetch_assoc($qam)) {
        // Симуляция запускается при заходе любого менеджера или админа
        if ($club_id == $m['id1'] || $club_id == $m['id2'] || (isset($user_data['level']) && $user_data['level'] >= 9) || $club_id) {
            if (function_exists('siv')) {
                siv($m['id']); // Вызов вашей функции генерации из manfunc.php
            }
        }
    }
}

// Финансовое обновление и реконструкция стадионов
$quvl = mysqli_query($db, "SELECT `budj` FROM `fman_clubs` WHERE id=131;");
if ($quvl && mysqli_num_rows($quvl) > 0) {
    $qaqa = mysqli_fetch_assoc($quvl);
    if ($qaqa['budj'] < ($realtime - 172800)) {
        // Реконструкция
        $qj124 = mysqli_query($db, "SELECT * FROM `fman_clubs` WHERE `stad_ned` > 0");
        if ($qj124) {
            while ($a124 = mysqli_fetch_assoc($qj124)) {
                $kmes4 = $a124['stad_ned'] - 1;
                mysqli_query($db, "UPDATE fman_clubs SET stad_ned=$kmes4 WHERE id={$a124['id']}");
                if ($kmes4 == 0) {
                    mysqli_query($db, "UPDATE fman_clubs SET stadv={$a124['stad_work']} WHERE id={$a124['id']}");
                    newsadd("На стадионе {$a124['stadion']} завершились работы по реконструкции.", $a124['id']);
                }
            }
        }
        // Сброс ежедневных лимитов
        mysqli_query($db, "UPDATE `fman_clubs` SET `uvol_count`=0, `buy_count`=0, `trans_count`=0");
        mysqli_query($db, "UPDATE `fman_clubs` SET `budj`=$realtime WHERE `id`=131");
    }
}

// Удаление дубликатов новостей (чистка лога)
if ($club_id) {
    $qhui = mysqli_query($db, "SELECT * FROM fman_news WHERE club_id=$club_id ORDER BY time DESC LIMIT 2;");
    if ($qhui && mysqli_num_rows($qhui) == 2) {
        $thui = []; $ihui = [];
        while ($ahui = mysqli_fetch_assoc($qhui)) {
            $thui[] = $ahui['text'];
            $ihui[] = $ahui['id'];
        }
        if ($thui[0] == $thui[1]) {
            mysqli_query($db, "DELETE FROM fman_news WHERE id={$ihui[0]};");
        }
    }
}

// Обработка трансферов по МСК
$qtpj = mysqli_query($db, "SELECT * FROM fman_players WHERE trans=1 AND trans_time < $realtime;");
if ($qtpj) {
    while ($atpj = mysqli_fetch_assoc($qtpj)) {
        if ($atpj['zarplat'] > 0) {
            $buyer_id = $atpj['zarplat'];
            $seller_id = $atpj['team_id'];
            
            $q_buyer = mysqli_query($db, "SELECT * FROM fman_clubs WHERE id=$buyer_id LIMIT 1");
            if ($q_buyer && mysqli_num_rows($q_buyer) > 0) {
                $atpj2 = mysqli_fetch_assoc($q_buyer);
                if ($atpj2['budj'] >= $atpj['cena']) {
                    mysqli_query($db, "UPDATE fman_players SET team_id=$buyer_id, trans=0, zarplat=0 WHERE id={$atpj['id']}");
                    mysqli_query($db, "UPDATE fman_clubs SET budj=budj-{$atpj['cena']} WHERE id=$buyer_id");
                    mysqli_query($db, "INSERT INTO fman_news SET time=$realtime, pl_id={$atpj['id']}, text='Трансфер игрока {$atpj['name']}', club_id=0");
                    
                    if ($seller_id > 0) {
                        mysqli_query($db, "UPDATE fman_clubs SET budj=budj+{$atpj['cena']} WHERE id=$seller_id");
                        newsadd("Игрок {$atpj['name']} продан за $" . number_format($atpj['cena']), $seller_id);
                    }
                }
            }
        } else {
            mysqli_query($db, "UPDATE fman_players SET trans=0 WHERE id={$atpj['id']}");
        }
    }
}

// Ежедневные выплаты
if ($club_id && isset($dataclub['last_pay'])) {
    $kpays = floor((time() - $dataclub['last_pay']) / 86400);
    if ($kpays >= 1) {
        $plus = $dataclub['plus'] * $kpays;
        mysqli_query($db, "UPDATE `fman_clubs` SET `last_pay`=" . time() . ", `budj`=`budj` + $plus WHERE `id`='$club_id'");
    }
}
?>
