<?php
require_once '../system/db.php';
// Устанавливаем часовой пояс МСК
date_default_timezone_set('Europe/Moscow');
include '../system/header.php';
require_once "manfunc.php"; 

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$act = isset($_GET['act']) ? mysqli_real_escape_string($db, $_GET['act']) : '';
$start = isset($_GET['start']) ? (int)$_GET['start'] : 0;
$kmess = 20; 

$now = time();

// --- БЛОК АВТОМАТИЧЕСКОГО ЗАПУСКА МАТЧЕЙ ---
$query_to_run = mysqli_query($db, "SELECT id FROM fman_matches WHERE time <= '$now' AND `end` = '0'");
while ($match_to_run = mysqli_fetch_assoc($query_to_run)) {
    $m_id = $match_to_run['id'];
    if (function_exists('siv')) {
        siv($m_id);
    }
}

if (!$id && isset($club_id)) $id = $club_id;
?>

<style>
    .match-container { padding: 10px; font-family: 'Segoe UI', sans-serif; }
    .match-card {
        background: white; border-radius: 15px; padding: 15px; margin-bottom: 12px;
        box-shadow: 0 4px 10px rgba(0,0,0,0.05); border-left: 5px solid #bdc3c7;
    }
    .match-finished { border-left-color: #2ecc71; }
    .match-upcoming { border-left-color: #3498db; }
    .match-info { font-size: 11px; color: #7f8c8d; text-transform: uppercase; margin-bottom: 8px; text-align: center; }
    .match-teams { display: flex; align-items: center; justify-content: space-between; gap: 10px; }
    .team-name { flex: 1; font-weight: bold; font-size: 14px; color: #2c3e50; }
    .team-left { text-align: right; }
    .team-right { text-align: left; }
    .match-score-link { text-decoration: none; color: inherit; display: block; }
    .match-score { 
        background: #f1f2f6; padding: 8px 12px; border-radius: 8px; 
        font-family: 'Monaco', monospace; font-weight: bold; font-size: 18px;
        min-width: 60px; text-align: center; color: #2d3436; transition: 0.2s;
    }
    .match-score:hover { background: #e2e4e9; }
    .match-time { font-size: 13px; color: #34495e; font-weight: bold; }
    .pagination { margin: 15px 0; text-align: center; }
    .pagination a { padding: 5px 10px; background: white; border: 1px solid #ddd; text-decoration: none; border-radius: 5px; color: #333; }
    .current-page { font-weight: bold; background: #3498db !important; color: white !important; border-color: #3498db !important; }
</style>

<div class="match-container">

<?php
if ($act == "p" || $act == "b") {
    $te = ($act == "p") ? "Последние" : "Ближайшие";
    $qt = mysqli_query($db, "SELECT name FROM fman_clubs WHERE id=$id LIMIT 1");
    $tdata = mysqli_fetch_assoc($qt);
    
    echo "<h2 align='center' style='color:#2c3e50; margin-bottom:20px;'>$te матчи <br><span style='color:#3498db;'>" . htmlspecialchars($tdata['name'] ?? '') . "</span></h2>";

    $where = ($act == "p") ? "WHERE `end`='1' AND (id1=$id OR id2=$id)" : "WHERE `end`='0' AND (id1=$id OR id2=$id)";
    $order = ($act == "p") ? "ORDER BY time DESC" : "ORDER BY time ASC";

    $q = mysqli_query($db, "SELECT * FROM fman_matches $where $order LIMIT $start, $kmess");
    $total = mysqli_fetch_row(mysqli_query($db, "SELECT COUNT(*) FROM fman_matches $where"))[0];

    if (mysqli_num_rows($q) > 0) {
        while ($a = mysqli_fetch_assoc($q)) {
            $t = function_exists('turn') ? turn($a['turn'], $a['tur'], $a['land'] ?? '') : "Матч";
            $card_class = ($a['end'] == 1) ? "match-finished" : "match-upcoming";
            
            echo "<div class='match-card $card_class'>";
            echo "<div class='match-info'>$t | " . date("d.m / H:i", $a['time']) . " МСК</div>";
            echo "<div class='match-teams'>";
            
            $name1 = ($a['id1'] == $id) ? "<u>{$a['kom1']}</u>" : $a['kom1'];
            echo "<div class='team-name team-left'>$name1</div>";
            
            // Ссылка на страницу матча
            echo "<a href='match.php?id={$a['id']}' class='match-score-link'>";
            echo "<div class='match-score'>";
            if ($a['end'] == 1) {
                echo "{$a['sc1']} : {$a['sc2']}";
            } else {
                echo "<span class='match-time'>" . date("H:i", $a['time']) . "</span>";
            }
            echo "</div></a>";
            
            $name2 = ($a['id2'] == $id) ? "<u>{$a['kom2']}</u>" : $a['kom2'];
            echo "<div class='team-name team-right'>$name2</div>";
            
            echo "</div>";
            echo "</div>";
        }
    } else {
        echo "<div class='note-item'>Список матчей пуст.</div>";
    }

    if ($total > $kmess) {
        echo "<div class='pagination'>";
        $pages = ceil($total / $kmess);
        for ($i = 1; $i <= $pages; $i++) {
            $st = ($i - 1) * $kmess;
            $class = ($st == $start) ? 'current-page' : '';
            echo "<a href='matches.php?act=$act&id=$id&start=$st' class='$class'>$i</a> ";
        }
        echo "</div>";
    }
} 
?>

    <div style="text-align:center; margin-top:20px;">
        <?php if($id): ?>
            <a href="club.php?id=<?php echo $id; ?>" style="text-decoration:none; color:#3498db; font-weight:bold;">⬅ Назад в клуб</a><br><br>
        <?php endif; ?>
        <a href="index.php" style="text-decoration:none; color:#7f8c8d;">🏠 В офис менеджера</a>
    </div>
</div>

<?php include '../system/footer.php'; ?>

