<?php
require_once '../system/db.php';
include '../system/header.php';

// Стили для страницы правил
echo "
<style>
    .rules-container { padding: 10px; font-family: 'Segoe UI', sans-serif; }
    .rule-card { 
        background: #fff; 
        border-radius: 12px; 
        padding: 15px; 
        margin-bottom: 15px; 
        box-shadow: 0 2px 8px rgba(0,0,0,0.05); 
        border-left: 4px solid #e74c3c;
    }
    .rule-card h3 { margin: 0 0 10px 0; font-size: 16px; color: #c0392b; display: flex; align-items: center; }
    .rule-card p { margin: 5px 0; font-size: 14px; color: #34495e; line-height: 1.5; }
    .rule-card ul { margin: 10px 0; padding-left: 20px; }
    .rule-card li { margin-bottom: 5px; font-size: 14px; }
    
    .info-box { 
        background: #e3f2fd; 
        padding: 15px; 
        border-radius: 12px; 
        border-left: 4px solid #3498db;
        margin-bottom: 15px;
        font-size: 14px;
    }
    .footer-nav { text-align: center; margin-top: 20px; }
    .btn-back { 
        display: inline-block; 
        padding: 10px 20px; 
        background: #f1f2f6; 
        border-radius: 20px; 
        text-decoration: none; 
        color: #2c3e50; 
        font-weight: 600;
        transition: 0.3s;
    }
    .btn-back:hover { background: #dfe4ea; }
</style>";

echo "<div class='rules-container'>";
echo "<h2 style='margin-left:5px;'>📜 Правила Менеджера</h2>";

// Инфо-блок
echo "<div class='info-box'>
        <b>Внимание!</b> Незнание правил не освобождает от ответственности. 
        Наказание определяется администрацией в зависимости от тяжести нарушения.
      </div>";

// Правило 1: Финансы
echo "<div class='rule-card'>
        <h3>💰 Финансовая политика</h3>
        <p>Запрещено просить деньги у администрации. Игровая валюта начисляется за:</p>
        <ul>
            <li>Призовые места в чемпионате и кубках.</li>
            <li>Участие в официальных конкурсах и акциях.</li>
            <li>Доходы от стадиона и спонсоров.</li>
        </ul>
      </div>";

// Правило 2: Трансферы (Самое важное)
echo "<div class='rule-card' style='border-left-color: #f39c12;'>
        <h3>⚖️ Трансферный рынок</h3>
        <p>Любые махинации ведут к немедленной блокировке (БАН). К махинациям относятся:</p>
        <ul>
            <li>Массовая скупка или увольнение игроков.</li>
            <li>Продажа/покупка игрока по цене, которая в 2 раза выше или ниже рыночной стоимости.</li>
            <li>Предложения клубам, у которых на данный момент нет менеджера.</li>
        </ul>
        <p><i>* Администрация не возвращает игроков, выставленных на трансфер «случайно».</i></p>
      </div>";

// Правило 3: Клубы и составы
echo "<div class='rule-card' style='border-left-color: #3498db;'>
        <h3>🏟 Управление клубом</h3>
        <p>1. Выбор клуба окончателен. Просьбы дать другой клуб (например, «Реал») игнорируются.</p>
        <p>2. Обмен клубами между пользователями запрещен без согласия администрации.</p>
        <p>3. Запрещен переход игроков из одного клуба в другой вслед за менеджером.</p>
        <p>4. Претензии по тех. характеристикам игроков или несоответствию реальных составов не принимаются.</p>
      </div>";

// Правило 4: Активность
echo "<div class='rule-card' style='border-left-color: #27ae60;'>
        <h3>🕒 Активность менеджера</h3>
        <p>Менеджер должен заходить в игру минимум <b>раз в 3 дня</b>.</p>
        <p>Максимальный срок отсутствия — 7 дней (только при условии предварительного уведомления администрации в ЛС).</p>
      </div>";

// Помощь
echo "<div class='info-box' style='background: #f9f9f9; border-left-color: #95a5a6;'>
        Остались вопросы? Напишите администрации или загляните в раздел помощи.
      </div>";

echo "<div class='footer-nav'>
        <a href='/pages/faq.php' class='btn-back' style='background: #3498db; color: #fff; margin-bottom:10px;'>📚 Читать F.A.Q.</a><br>
        <a href='index.php' class='btn-back'>⬅ Вернуться в Менеджер</a>
      </div>";

echo "</div>"; // Конец контейнера

include '../system/footer.php';
?>
