<?php
// Подключаем ваши рабочие файлы
require_once '../system/db.php';
include '../system/header.php';
require_once "manfunc.php"; 

$textl = 'Рейтинг клубов';
echo "<style>
    .rait-table { width: 100%; border-collapse: collapse; background: #fff; border-radius: 12px; overflow: hidden; box-shadow: 0 4px 12px rgba(0,0,0,0.05); }
    .rait-table th { background: #2c3e50; color: #fff; padding: 12px; font-size: 12px; text-transform: uppercase; }
    .rait-table td { padding: 12px; border-bottom: 1px solid #f1f2f6; text-align: center; }
    .rait-table tr:hover { background: #f8f9fa; }
    .rank-cell { width: 50px; font-weight: bold; font-size: 16px; }
    .club-cell { text-align: left !important; }
    .fan-count { font-weight: bold; color: #27ae60; }
    .medal-1 { color: #f1c40f; } /* Золото */
    .medal-2 { color: #bdc3c7; } /* Серебро */
    .medal-3 { color: #cd7f32; } /* Бронза */
    .my-club-row { background: #fff9c4 !important; border-left: 4px solid #f1c40f; }
</style>";

echo "<div class='card-title' style='text-align:center; font-size:18px; color:#2c3e50;'>🏆 Мировой рейтинг клубов</div>";

// Инициализация пагинации (стандарт JohnCMS)
$total_q = mysqli_query($db, "SELECT COUNT(*) FROM `fman_clubs` WHERE `id` != 131");
$total = mysqli_fetch_row($total_q)[0];

$start = isset($_GET['start']) ? intval($_GET['start']) : 0;
$kmess = 20; // Количество клубов на страницу

// Запрос рейтинга (сортировка по количеству фанатов)
$q = mysqli_query($db, "SELECT * FROM `fman_clubs` WHERE `id` != 131 ORDER BY `fan` DESC LIMIT $start, $kmess");

if ($total > 0) {
    echo "<table class='rait-table'>";
    echo "<tr><th>Поз.</th><th class='club-cell'>Команда</th><th>Фанаты</th></tr>";

    $n = $start;
    while ($a = mysqli_fetch_assoc($q)) {
        $n++;
        
        // Оформление топ-мест
        $rank_display = $n;
        if ($n == 1) $rank_display = "<span class='medal-1'>🥇</span>";
        elseif ($n == 2) $rank_display = "<span class='medal-2'>🥈</span>";
        elseif ($n == 3) $rank_display = "<span class='medal-3'>🥉</span>";

        // Подсветка своего клуба
        $row_class = ($a['id'] == $club_id) ? "class='my-club-row'" : "";
        
        echo "<tr $row_class>";
        echo "<td class='rank-cell'>$rank_display</td>";
        echo "<td class='club-cell'>";
        
        if ($a['id'] != $club_id) {
            echo "<a href='club.php?id={$a['id']}' style='text-decoration:none; color:#2980b9; font-weight:600;'>{$a['name']}</a>";
        } else {
            echo "<b>{$a['name']}</b> <small>(Вы)</small>";
        }
        
        echo "</td>";
        echo "<td class='fan-count'>" . number_format($a['fan'], 0, '.', ' ') . "</td>";
        echo "</tr>";
    }
    echo "</table>";

    // Пагинация
    if ($total > $kmess) {
        echo '<div class="topmenu" style=' . "margin:15px 0;" . '>' . functions::display_pagination('rait.php?', $start, $total, $kmess) . '</div>';
        
        echo '<div class="menu" style="text-align:center; background:none; border:none;">
                <form action="rait.php" method="get" style="display:inline-block;">
                    <input type="number" name="page" placeholder="Стр." style="width:60px; padding:5px; border-radius:5px; border:1px solid #ccc;"/>
                    <input type="submit" value="Перейти" class="btn-land" style="padding:5px 10px; cursor:pointer;"/>
                </form>
              </div>';
    }
} else {
    echo "<div class='note-item'>Список клубов пуст.</div>";
}

// Нижнее меню
echo "<div class='footer-nav' style='margin-top:20px; text-align:center;'>";
if (isset($_GET['id'])) {
    $view_id = intval($_GET['id']);
    $qtj = mysqli_query($db, "SELECT `name` FROM `fman_clubs` WHERE `id` = $view_id");
    if ($tdat = mysqli_fetch_assoc($qtj)) {
        echo "<div class='menu-item' style='display:inline-block; margin-bottom:10px;'><a href='club.php?id=$view_id'>Вернуться в {$tdat['name']}</a></div><br/>";
    }
}
echo "<a href='index.php' class='btn-land' style='background:#f1f2f6; color:#2c3e50;'>⬅ В офис менеджера</a>";
echo "</div>";

include '../system/footer.php';
?>
