<?php
require_once '../system/db.php';
include '../system/header.php';

$state_code = isset($_GET['state']) ? mysqli_real_escape_string($db, $_GET['state']) : '';
$kmess = 10;
$start = isset($_GET['start']) ? intval($_GET['start']) : 0;
if ($start < 0) $start = 0;

echo "<style>
    .striker-card { 
        background: #fff; border-radius: 12px; padding: 12px; margin-bottom: 10px; 
        display: flex; align-items: center; box-shadow: 0 2px 6px rgba(0,0,0,0.05);
        border: 1px solid #f0f0f0; position: relative;
    }
    .rank-badge {
        position: absolute; top: -5px; left: -5px; background: #34495e; color: #fff;
        width: 24px; height: 24px; border-radius: 50%; font-size: 11px;
        display: flex; align-items: center; justify-content: center; font-weight: bold;
    }
    .top-1 { background: #f1c40f !important; color: #000 !important; }
    .striker-photo { width: 60px; height: 60px; border-radius: 8px; object-fit: cover; margin-right: 15px; background: #eee; }
    .striker-info { flex-grow: 1; }
    .striker-name { font-weight: bold; font-size: 15px; color: #2c3e50; text-decoration: none; }
    .striker-club { font-size: 12px; color: #7f8c8d; margin-top: 3px; }
    .striker-goals { 
        text-align: center; min-width: 50px; padding: 5px; 
        background: #e8f5e9; border-radius: 10px; color: #2e7d32; font-weight: bold; 
    }
    .striker-goals span { display: block; font-size: 10px; text-transform: uppercase; opacity: 0.7; }
</style>";

if (empty($state_code)) {
    // --- СПИСОК СТРАН ---
    echo "<div class='card-title'>Выберите лигу</div>";
    $sql = mysqli_query($db, "SELECT * FROM `fman_lands` ORDER BY `name` ASC");
    
    echo "<div class='menu-grid'>";
    while ($state = mysqli_fetch_assoc($sql)) {
        echo "<a href='?state={$state['code']}' class='menu-item'>
                <img src='flags_icon/{$state['code']}.png' style='width:24px; margin-bottom:5px;'><br>
                {$state['name']}
              </a>";
    }
    echo "</div>";
} else {
    // --- РЕЙТИНГ БОМБАРДИРОВ КОНКРЕТНОЙ СТРАНЫ ---
    $state_q = mysqli_query($db, "SELECT * FROM `fman_lands` WHERE `code` = '$state_code' LIMIT 1");
    if (mysqli_num_rows($state_q) > 0) {
        $state = mysqli_fetch_assoc($state_q);
        
        echo "<div class='card-title' style='display:flex; align-items:center;'>
                <img src='flags_icon/{$state['code']}.png' style='margin-right:10px;'> 
                Топ бомбардиров: {$state['name']}
              </div>";

        // Подсчет общего количества игроков в этой лиге, у которых есть голы
        $count_q = mysqli_query($db, "
            SELECT COUNT(*) 
            FROM `fman_players` 
            INNER JOIN `fman_clubs` ON `fman_players`.`team_id` = `fman_clubs`.`id`
            WHERE `fman_clubs`.`land` = '$state_code' AND `fman_players`.`goals` > 0
        ");
        $total = mysqli_fetch_row($count_q)[0];

        // Основной запрос с объединением таблиц для получения клуба и имени менеджера (через users)
        $sql = mysqli_query($db, "
            SELECT p.*, c.name as cname, c.user_id, u.login as manager_name
            FROM `fman_players` p
            INNER JOIN `fman_clubs` c ON p.team_id = c.id
            LEFT JOIN `users` u ON c.user_id = u.id
            WHERE c.land = '$state_code' AND p.goals > 0
            ORDER BY p.goals DESC, p.name ASC
            LIMIT $start, $kmess
        ");

        if (mysqli_num_rows($sql) > 0) {
            $current_rank = $start + 1;
            while ($player = mysqli_fetch_assoc($sql)) {
                $rank_class = ($current_rank == 1) ? 'top-1' : '';
                $photo = !empty($player['foto']) ? $player['foto'] : 'img/no_photo.jpg';
                $manager = !empty($player['manager_name']) ? $player['manager_name'] : 'Нет менеджера';

                echo "<div class='striker-card'>
                        <div class='rank-badge $rank_class'>$current_rank</div>
                        <img src='$photo' class='striker-photo' alt=''>
                        <div class='striker-info'>
                            <a href='player.php?id={$player['id']}' class='striker-name'>{$player['name']}</a>
                            <div class='striker-club'>
                                🏟 Клуб: <a href='club.php?id={$player['team_id']}'>{$player['cname']}</a><br>
                                👤 Тренер: $manager
                            </div>
                        </div>
                        <div class='striker-goals'>
                            {$player['goals']}
                            <span>Голов</span>
                        </div>
                    </div>";
                $current_rank++;
            }

            // Постраничная навигация
            if ($total > $kmess && class_exists('functions')) {
                echo '<div class="note-item">' . functions::display_pagination('rait_bomb.php?state='.$state_code.'&', $start, $total, $kmess) . '</div>';
            }
            
            echo "<div class='card-title' style='text-align:right; font-size:12px;'>Всего игроков с голами: $total</div>";
        } else {
            echo "<div class='note-item'>В этой лиге пока еще никто не забил голов.</div>";
        }
    } else {
        echo "<div class='note-item' style='border-left-color:red;'>Лига не найдена!</div>";
    }
}

// Навигация
echo "<div class='footer-nav' style='display:flex; justify-content:center; gap:10px; margin-top:20px;'>
        <a href='rait_bomb.php' class='btn-land' style='background:#eee;'>⬅ К списку лиг</a>
        <a href='index.php' class='btn-land' style='background:#3498db; color:#fff;'>🏠 В менеджер</a>
      </div>";

include '../system/footer.php';
?>

