<?php
require_once '../system/db.php';
include '../system/header.php';

// 1. АВТОМАТИЧЕСКОЕ ОПРЕДЕЛЕНИЕ КЛУБА
$my_id = isset($_SESSION['user_id']) ? intval($_SESSION['user_id']) : 0;
$club_res = mysqli_query($db, "SELECT * FROM `fman_clubs` WHERE `user_id` = '$my_id' LIMIT 1");
$dataclub = mysqli_fetch_assoc($club_res);
$club_id = $dataclub['id'] ?? 0; // Теперь $club_id будет доступен всему скрипту

?>
<style>
    .spons-container { display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 15px; padding: 10px; }
    .spons-card { 
        background: #fff; border-radius: 12px; overflow: hidden; 
        box-shadow: 0 4px 15px rgba(0,0,0,0.05); border: 1px solid #eee; 
        transition: 0.3s; position: relative;
    }
    .spons-card:hover { transform: translateY(-5px); box-shadow: 0 8px 25px rgba(0,0,0,0.1); }
    .spons-banner { 
        height: 80px; background: #f8f9fa; display: flex; 
        align-items: center; justify-content: center; border-bottom: 1px solid #f0f0f0;
    }
    .spons-logo { max-width: 150px; max-height: 60px; filter: grayscale(20%); }
    .spons-content { padding: 15px; }
    .spons-title { font-size: 18px; font-weight: bold; color: #2c3e50; margin-bottom: 10px; }
    .spons-info { font-size: 13px; color: #7f8c8d; line-height: 1.6; }
    .spons-info b { color: #27ae60; }
    .spons-action { 
        margin-top: 15px; padding-top: 15px; border-top: 1px dashed #eee; 
        display: flex; justify-content: space-between; align-items: center; 
    }
    .btn-contract { 
        background: #2c3e50; color: #fff; padding: 8px 16px; 
        border-radius: 6px; text-decoration: none; font-weight: bold; font-size: 13px;
    }
    .my-spons-label { 
        position: absolute; top: 10px; right: 10px; background: #27ae60; 
        color: #fff; font-size: 10px; padding: 3px 8px; border-radius: 10px; text-transform: uppercase;
    }
</style>



<?php

if (!$club_id) {
    echo "<div class='note-item' style='border-left: 4px solid #e74c3c; background: #fff5f5; padding: 20px;'>
            <b>Ошибка доступа!</b><br>Вам необходимо возглавить клуб для работы со спонсорами!
          </div>";
} else {
    $new = isset($_GET['new']) ? intval($_GET['new']) : 0;
    $view_club = isset($_GET['club']) ? intval($_GET['club']) : 0;

    // --- ПОДПИСАНИЕ КОНТРАКТА ---
    if ($new > 0) {
        $q = mysqli_query($db, "SELECT * FROM `fman_spons` WHERE `id` = '$new' LIMIT 1");
        $b = mysqli_fetch_assoc($q);

        if (!$b) {
            echo "<div class='note-item' style='border-left-color:#e74c3c;'>Спонсор не найден.</div>";
        } elseif ($b['pay'] > $dataclub['budj']) {
            echo "<div class='note-item' style='border-left-color:#e74c3c;'>У клуба недостаточно средств для выплаты агентских комиссионных ($".number_format($b['pay']).").</div>";
        } else {
            // Удаляем старый контракт и записываем новый
            mysqli_query($db, "DELETE FROM `fman_clubs_spons` WHERE `club_id` = '$club_id'");
            mysqli_query($db, "INSERT INTO `fman_clubs_spons` (`club_id`, `sid`) VALUES ('$club_id', '$new')");
            
            // Обновляем бюджет и сумму спонсорских выплат в таблице клуба
            mysqli_query($db, "UPDATE `fman_clubs` SET `budj` = `budj` - '{$b['pay']}', `spons` = '{$b['plus']}' WHERE `id` = '$club_id' LIMIT 1");
            
            echo "<div class='note-item' style='border-left-color:#27ae60;'>Контракт с <b>{$b['name']}</b> успешно подписан! Теперь вы будете получать <b>$".number_format($b['plus'])."</b> за каждый матч.</div>";
            
            // Обновляем локальные данные для корректного отображения ниже
            $dataclub['budj'] -= $b['pay'];
        }
        echo "<div class='menu-item' style='text-align:center;'><a href='spons.php'>Вернуться к спонсорам</a></div>";

    // --- ПРОСМОТР СПОНСОРА ЧУЖОГО КЛУБА ---
    } elseif ($view_club > 0) {
        $q_club = mysqli_query($db, "SELECT name FROM `fman_clubs` WHERE `id` = '$view_club' LIMIT 1");
        if(mysqli_num_rows($q_club) > 0) {
            $dc_view = mysqli_fetch_assoc($q_club);
            echo "<div class='card-title'>Спонсор клуба ".htmlspecialchars($dc_view['name'])."</div>";

            $sql = mysqli_query($db, "SELECT s.* FROM `fman_clubs_spons` cs JOIN `fman_spons` s ON s.id = cs.sid WHERE cs.club_id = '$view_club' LIMIT 1");
            if (mysqli_num_rows($sql) > 0) {
                $b = mysqli_fetch_assoc($sql);
                echo "<div class='spons-container'><div class='spons-card'>
                        <div class='spons-banner'><img src='spons/{$b['pic']}' class='spons-logo' onerror=\"this.src='../img/spons_default.png'\"></div>
                        <div class='spons-content'>
                            <div class='spons-title'>{$b['name']}</div>
                            <div class='spons-info'>Выплата за матч: <b>$".number_format($b['plus'])."</b></div>
                        </div>
                      </div></div>";
            } else {
                echo "<div class='note-item'>У клуба нет действующего спонсора.</div>";
            }
        }

    // --- ГЛАВНАЯ СТРАНИЦА ---
    } else {
        // Мой текущий спонсор
        $my_sql = mysqli_query($db, "SELECT s.* FROM `fman_clubs_spons` cs JOIN `fman_spons` s ON s.id = cs.sid WHERE cs.club_id = '$club_id' LIMIT 1");
        if (mysqli_num_rows($my_sql) > 0) {
            echo "<div class='card-title'>🤝 Действующий контракт (Бюджет: $".number_format($dataclub['budj']).")</div>";
            $b = mysqli_fetch_assoc($my_sql);
            echo "<div class='spons-container'><div class='spons-card' style='border: 2px solid #27ae60;'>
                    <span class='my-spons-label'>Активен</span>
                    <div class='spons-banner'><img src='spons/{$b['pic']}' class='spons-logo' onerror=\"this.src='../img/spons_default.png'\"></div>
                    <div class='spons-content'>
                        <div class='spons-title'>{$b['name']}</div>
                        <div class='spons-info'>Текущий доход: <b>$".number_format($b['plus'])."</b> за игру.</div>
                    </div>
                  </div></div>";
        }

        // Доступные предложения
        echo "<div class='card-title'>📈 Новые предложения</div>";
        $sql = mysqli_query($db, "SELECT * FROM `fman_spons` WHERE id NOT IN (SELECT sid FROM fman_clubs_spons WHERE club_id = '$club_id')");
        
        if (mysqli_num_rows($sql) > 0) {
            echo "<div class='spons-container'>";
            while ($b = mysqli_fetch_assoc($sql)) {
                echo "<div class='spons-card'>
                        <div class='spons-banner'><img src='spons/{$b['pic']}' class='spons-logo' onerror=\"this.src='../img/spons_default.png'\"></div>
                        <div class='spons-content'>
                            <div class='spons-title'>{$b['name']}</div>
                            <div class='spons-info'>
                                Стоимость входа: <b>$".number_format($b['pay'])."</b><br>
                                Выплата за матч: <b>$".number_format($b['plus'])."</b>
                            </div>
                            <div class='spons-action'>
                                <div style='font-size:11px; color:#95a5a6;'>Контракт на сезон</div>
                                <a href='spons.php?new={$b['id']}' class='btn-contract' onclick=\"return confirm('Подписание нового контракта аннулирует старый. Продолжить?')\">Подписать</a>
                            </div>
                        </div>
                      </div>";
            }
            echo "</div>";
        } else {
            echo "<div class='note-item'>На данный момент новых предложений нет.</div>";
        }
    }
}

echo "<div class='footer-nav' style='text-align:center; margin-top:20px;'>
        <a href='index.php' class='btn-land' style='background:#f1f2f6; padding: 10px 20px; border-radius: 8px; text-decoration: none; color: #333;'>⬅ В менеджер</a>
      </div>";

include '../system/footer.php';
?>

