<?php
require_once '../system/db.php';
include '../system/header.php';

// Заголовок страницы
$textl = 'Справка по Менеджеру';
?>

<style>
    .faq-container { padding: 15px; line-height: 1.6; font-size: 14px; }
    .faq-item { background: #fff; padding: 12px; border-radius: 8px; margin-bottom: 10px; border-left: 4px solid #007aff; box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
    .faq-item b { color: #007aff; display: block; margin-bottom: 5px; }
    .stat-badge { display: inline-block; background: #f2f2f7; padding: 2px 8px; border-radius: 4px; font-weight: bold; min-width: 30px; text-align: center; margin-right: 5px; }
    .prize-list { background: #fff; padding: 15px; border-radius: 12px; border: 1px solid #ddd; }
    .prize-row { display: flex; justify-content: space-between; border-bottom: 1px solid #eee; padding: 5px 0; }
</style>

<div class="app-bar" style="background: #007aff; color: #fff; padding: 15px; display: flex; align-items: center; gap: 10px;">
    <a href="index.php" style="color: #fff; text-decoration: none;">🏠</a>
    <b>Справка по Менеджеру</b>
</div>

<div class="faq-container">
    
    <div class="faq-item">
        Игры чемпионата проходят через день. В свободное время вы можете проводить товарищеские матчи для проверки состава.
    </div>

    <div class="faq-item">
        <b>Как взять команду?</b>
        На главной странице Менеджера нажмите «Выбрать клуб». Вам откроется список свободных команд, которые можно возглавить.
    </div>

    <div class="faq-item">
        <b>Мой клуб</b>
        Здесь собрана вся статистика, рейтинг и данные вашей команды. В этом же разделе можно заниматься улучшением показателей.
    </div>

    <div class="faq-item">
        <b>Постройки</b>
        Стройте инфраструктуру (бар, школа и т.д.), чтобы обеспечить клубу стабильный доход.
    </div>

    <div class="faq-item">
        <b>Управление составом</b>
        Выбор основного состава и тактической расстановки на предстоящий матч.
    </div>

    <div class="faq-item">
        <b>Список игроков</b>
        Раздел для проведения тренировок. Здесь же можно уволить игроков, которые не подходят команде.
    </div>

    <div class="faq-item">
        <b>Трансферный рынок</b>
        Место для покупки, продажи и обмена футболистов между клубами.
    </div>

    <div class="faq-item">
        <b>Как продать игрока?</b>
        Зайдите в «Мой клуб», выберите футболиста, нажмите «Продать» и установите стоимость. После подтверждения он появится на рынке.
    </div>

    <h3>📊 Сокращения в таблицах</h3>
    <div class="faq-item">
        <span class="stat-badge">Г</span> Мячи (Забито / Пропущено)<br>
        <span class="stat-badge">В</span> Выигранные матчи<br>
        <span class="stat-badge">Н</span> Ничьи<br>
        <span class="stat-badge">П</span> Проигранные матчи<br>
        <span class="stat-badge">О</span> Очки в турнирной таблице
    </div>

    <h3>🛡 Позиции игроков</h3>
    [attachment_0](attachment)
    <div class="faq-item" style="display: grid; grid-template-columns: 1fr 1fr; gap: 5px;">
        <div><span class="stat-badge">В</span> Вратарь</div>
        <div><span class="stat-badge">ЦЗ</span> Центр. защитник</div>
        <div><span class="stat-badge">ЛЗ</span> Левый защ.</div>
        <div><span class="stat-badge">ПЗ</span> Правый защ.</div>
        <div><span class="stat-badge">ОП</span> Опорник</div>
        <div><span class="stat-badge">АП</span> Атак. полузащ.</div>
        <div><span class="stat-badge">ЛП</span> Лев. полузащ.</div>
        <div><span class="stat-badge">ПП</span> Прав. полузащ.</div>
        <div><span class="stat-badge">Н</span> Нападающий</div>
    </div>

    <h3>🏆 Призовые фонды</h3>
    <div class="prize-list">
        <div class="prize-row"><span>Чемпионат (1 место)</span> <b>40 млн.</b></div>
        <div class="prize-row"><span>Чемпионат (2 место)</span> <b>25 млн.</b></div>
        <div class="prize-row"><span>Лига Чемпионов (1 место)</span> <b>50 млн.</b></div>
        <div class="prize-row"><span>Лига Европы (1 место)</span> <b>40 млн.</b></div>
        <div class="prize-row"><span>Нац. Кубок (Победа)</span> <b>20 млн.</b></div>
        <div class="prize-row"><span>Бомбардиры (Топ-3)</span> <b>1-3 млн.</b></div>
    </div>

    <div style="margin-top: 20px; text-align: center; color: #8e8e93; font-style: italic;">
        Менеджер постоянно обновляется. Желаем удачи в достижении футбольных вершин!
    </div>

    <div style="margin-top: 20px; display: flex; flex-direction: column; gap: 10px;">
        <a href="index.php" class="btn-primary" style="background:#34495e; text-align:center; text-decoration:none; padding:12px; border-radius:8px; color:#fff;">Вернуться в Менеджер</a>
        <a href="/index.php" style="text-align:center; color:#007aff; text-decoration:none;">На главную сайта</a>
    </div>
</div>

<?php include '../system/footer.php'; ?>
