<?php
require_once '../system/db.php';
include '../system/header.php';
require_once "manfunc.php"; 

// Получаем ID стадиона
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$act = isset($_GET['act']) ? $_GET['act'] : 'default';

// Загружаем данные клуба/стадиона
$q = mysqli_query($db, "SELECT * FROM fman_clubs WHERE id = '$id' LIMIT 1");
$a = mysqli_fetch_assoc($q);

if (!$a) {
    echo "<div class='note-item'>Стадион не найден.</div>";
    include '../system/footer.php'; exit;
}

// Проверка на владение (для кнопок управления)
$is_owner = ($club_id == $id);

?>

<style>
    .stad-header { background: linear-gradient(rgba(0,0,0,0.6), rgba(0,0,0,0.6)), url('img/stadium_bg.jpg'); background-size: cover; padding: 30px 15px; text-align: center; color: white; border-radius: 0 0 20px 20px; }
    .stad-name { font-size: 22px; font-weight: bold; text-transform: uppercase; letter-spacing: 1px; }
    .stad-city { font-size: 14px; opacity: 0.9; }
    
    .stad-card { background: white; border-radius: 15px; padding: 20px; box-shadow: 0 4px 15px rgba(0,0,0,0.05); margin: -20px 10px 15px; position: relative; z-index: 2; }
    .stad-info-row { display: flex; justify-content: space-between; padding: 12px 0; border-bottom: 1px solid #f1f2f6; }
    .stad-info-row:last-child { border-bottom: none; }
    .info-label { color: #7f8c8d; font-size: 14px; }
    .info-value { font-weight: bold; color: #2c3e50; }

    .work-box { background: #fff9e6; border: 1px solid #ffeaa7; border-radius: 12px; padding: 15px; margin: 15px 10px; }
    .progress-bg { background: #dfe6e9; height: 10px; border-radius: 5px; margin: 10px 0; overflow: hidden; }
    .progress-bar { background: #f1c40f; height: 100%; transition: 0.5s; }

    .btn-rek { display: block; background: #27ae60; color: white; text-align: center; padding: 12px; border-radius: 10px; text-decoration: none; font-weight: bold; margin: 10px; }
    .rek-form { background: white; padding: 20px; border-radius: 15px; margin: 10px; box-shadow: 0 4px 15px rgba(0,0,0,0.05); }
    .rek-select { width: 100%; padding: 10px; border-radius: 8px; border: 1px solid #ddd; margin-bottom: 15px; }
    .rek-hint { font-size: 12px; color: #7f8c8d; background: #f8f9fa; padding: 10px; border-radius: 8px; line-height: 1.4; }
</style>

<?php
switch($act)
{
    default:
    ?>
    <div class="stad-header">
        <div class="stad-name"><?php echo htmlspecialchars($a['stadion']); ?></div>
        <div class="stad-city">📍 <?php echo htmlspecialchars($a['city']); ?></div>
    </div>

    <div class="stad-card">
        <div class="stad-info-row">
            <span class="info-label">Хозяин арены:</span>
            <span class="info-value"><?php echo htmlspecialchars($a['name']); ?></span>
        </div>
        <div class="stad-info-row">
            <span class="info-label">Текущая вместимость:</span>
            <span class="info-value"><?php echo number_format($a['stadv'], 0, ',', ' '); ?> мест</span>
        </div>
        <div class="stad-info-row">
            <span class="info-label">Содержание:</span>
            <span class="info-value" style="color:#e74c3c;">$<?php echo number_format(($a['stadv'] * 20), 0, ',', ' '); ?> / нед.</span>
        </div>
    </div>

    <?php
    // Если идет стройка
    if ($a['stad_ned'] > 0) {
        // Рассчитаем % прогресса (условно)
        $total_target = abs($a['stad_work'] - $a['stadv']);
        echo "<div class='work-box'>
                <div style='font-weight:bold; color:#d35400;'>🏗️ Реконструкция в процессе</div>
                <div class='progress-bg'><div class='progress-bar' style='width: 45%'></div></div>
                <div style='font-size:13px;'>
                    Цель: <b>".number_format($a['stad_work'],0,'.',' ')."</b> мест<br>
                    Осталось: <b>{$a['stad_ned']}</b> вирт. недель
                </div>
              </div>";
    }

    // Кнопка реконструкции (только владельцу и если нет текущей стройки)
    if ($is_owner && !$a['stad_ned']) {
        echo "<a href='stad.php?id=$id&act=rek' class='btn-rek'>⚒️ РЕКОНСТРУИРОВАТЬ</a>";
    }
    break;

    case 'rek':
    if (!isset($_POST['submit'])) {
        ?>
        <div class="rek-form">
            <h2 align="center">Реконструкция</h2>
            <form action="stad.php?id=<?php echo $id; ?>&act=rek" method="post">
                <label class="info-label">Выберите количество мест:</label>
                <select name="mest" class="rek-select">
                    <?php for($i=1; $i<51; $i++) echo "<option value='$i'>" . ($i*1000) . "</option>"; ?>
                </select>

                <label class="info-label">Вид работ:</label>
                <select name="vid" class="rek-select">
                    <option value="1">➕ Построить (расширить)</option>
                    <option value="2">➖ Разобрать (уменьшить)</option>
                </select>

                <input type="submit" name="submit" value="НАЧАТЬ РАБОТЫ" class="btn-rek" style="border:none; width:100%; cursor:pointer;">
                
                <div class="rek-hint" style="margin-top:15px;">
                    💰 <b>Стоимость:</b> $2 000 000 за 1000 мест.<br>
                    📏 <b>Лимит:</b> от 500 до 200 000 мест.<br>
                    ⏳ <b>Скорость:</b> 2000 мест за одну вирт. неделю.
                </div>
            </form>
        </div>
        <?php
    } else {
        $mest_input = (int)$_POST['mest'];
        $stoim = $mest_input * 2000000;
        $vid = (int)$_POST['vid'];
        $error = false;

        if ($dataclub['budj'] < $stoim) $error = "У вас не хватает средств ($".number_format($stoim).")!";
        
        $change = ($vid == 1) ? ($mest_input * 1000) : -($mest_input * 1000);
        $new_capacity = $a['stadv'] + $change;

        if ($new_capacity > 200000) $error = "Максимальная вместимость арены — 200 000 мест!";
        if ($new_capacity < 500) $error = "Минимальная вместимость арены — 500 мест!";

        if ($error) {
            echo "<div class='note-item' style='border-left:4px solid #e74c3c;'>$error</div>";
        } else {
            $weeks = round($mest_input / 2); // Ваша оригинальная формула времени
            if($weeks < 1) $weeks = 1;

            // Записываем стройку
            mysqli_query($db, "UPDATE fman_clubs SET stad_work='$new_capacity', stad_ned='$weeks' WHERE id='$id'");
            // Списываем деньги
            mysqli_query($db, "UPDATE fman_clubs SET budj=budj-'$stoim' WHERE id='$club_id'");
            
            echo "<div class='note-item' style='border-left:4px solid #27ae60;'>
                    <b>Заявка принята!</b><br>
                    Рабочие приступили к реконструкции. Срок: $weeks нед.
                  </div>";
        }
        echo "<div style='text-align:center; margin:10px;'><a href='stad.php?id=$id'>Вернуться на стадион</a></div>";
    }
    break;
}
?>

<div style="margin: 20px 10px; border-top: 1px solid #eee; padding-top: 15px;">
    <div class="phdr" style="background:none; border:none;">
        <a href="club.php?id=<?php echo $id; ?>" style="color:#3498db; font-weight:bold; text-decoration:none;">⬅ Клуб <?php echo $a['name']; ?></a><br><br>
        <a href="index.php" style="color:#7f8c8d; text-decoration:none;">🏠 Футбольный менеджер</a>
    </div>
</div>

<?php include '../system/footer.php'; ?>

