<?php
require_once '../system/db.php';
// Устанавливаем МСК перед загрузкой чего-либо
date_default_timezone_set('Europe/Moscow');
include '../system/header.php';

if (!isset($_SESSION['user_id'])) exit("Авторизуйтесь");

$my_id = (int)$_SESSION['user_id'];
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0; 

$res_my = mysqli_query($db, "SELECT * FROM fman_clubs WHERE user_id = $my_id LIMIT 1");
$my_club = mysqli_fetch_assoc($res_my);

$res_target = mysqli_query($db, "SELECT * FROM fman_clubs WHERE id = $id LIMIT 1");
$target_club = mysqli_fetch_assoc($res_target);

if (!$my_club || !$target_club) exit("Клуб не найден");

// Теперь time() берется с учетом Europe/Moscow из-за date_default_timezone_set
$realtime = time();

if (isset($_POST['accept'])) {
    $req_id = (int)$_POST['req_id'];
    $req = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM fman_tm_requests WHERE id = $req_id AND receiver_club_id = {$my_club['id']}"));
    
    if ($req) {
        // Назначаем матч через 30 минут от текущего МСК
        $tm = $realtime + 1800; 
        
        if ($req['pole'] == 1) {
            $id1 = $req['sender_club_id']; $id2 = $req['receiver_club_id'];
        } else {
            $id1 = $req['receiver_club_id']; $id2 = $req['sender_club_id'];
        }

        $n1 = mysqli_fetch_assoc(mysqli_query($db, "SELECT name FROM fman_clubs WHERE id=$id1"))['name'];
        $n2 = mysqli_fetch_assoc(mysqli_query($db, "SELECT name FROM fman_clubs WHERE id=$id2"))['name'];

        // Добавляем матч в базу
        mysqli_query($db, "INSERT INTO fman_matches (time, turn, tur, kom1, id1, kom2, id2, `end`, sc1, sc2) VALUES ($tm, 'tm', 1, '$n1', $id1, '$n2', $id2, 0, 0, 0)");
        
        mysqli_query($db, "DELETE FROM fman_tm_requests WHERE id = $req_id");
        
        echo "<div class='note-item' style='border-left:4px solid green;'>✅ Матч назначен на МСК: ".date("H:i", $tm)."!</div>";
    }
}
// ... (остальной код отклонения и отправки без изменений, так как time() теперь МСК) ...
elseif (isset($_POST['decline'])) {
    $req_id = (int)$_POST['req_id'];
    mysqli_query($db, "DELETE FROM fman_tm_requests WHERE id = $req_id AND receiver_club_id = {$my_club['id']}");
    echo "<div class='note-item'>❌ Вызов отклонен.</div>";
}
elseif (isset($_POST['send'])) {
    $pole = (int)$_POST['pole'];
    mysqli_query($db, "INSERT INTO fman_tm_requests (sender_club_id, receiver_club_id, pole, time_sent) VALUES ({$my_club['id']}, $id, $pole, $realtime)");
    echo "<div class='note-item'>✅ Заявка отправлена менеджеру команды {$target_club['name']}.</div>";
}
else {
    $check_inc = mysqli_query($db, "SELECT * FROM fman_tm_requests WHERE sender_club_id = $id AND receiver_club_id = {$my_club['id']} LIMIT 1");
    $inc = mysqli_fetch_assoc($check_inc);
    if ($inc) {
        $p_txt = ($inc['pole'] == 1) ? "на поле соперника" : "на вашем поле";
        echo "<div class='info-card' style='margin:10px; text-align:center;'>
                <h3>Входящий вызов!</h3>
                <p>Команда <b>{$target_club['name']}</b> предлагает сыграть $p_txt.</p>
                <form method='post'>
                    <input type='hidden' name='req_id' value='{$inc['id']}'>
                    <button type='submit' name='accept' class='action-item' style='background:#27ae60; color:#fff; width:100%; border:0;'>Принять</button><br><br>
                    <button type='submit' name='decline' class='action-item' style='background:#e74c3c; color:#fff; width:100%; border:0;'>Отклонить</button>
                </form>
              </div>";
    } else {
        ?>
        <div class="info-card" style="margin:10px; text-align:center;">
            <h3>Вызов на матч</h3>
            <form method="post">
                <p>Где играть?</p>
                <select name="pole" style="width:100%; padding:10px; margin-bottom:15px;">
                    <option value="1">На поле соперника (<?php echo $target_club['name']; ?>)</option>
                    <option value="2">На нашем поле (<?php echo $my_club['name']; ?>)</option>
                </select>
                <button type="submit" name="send" class="action-item" style="background:var(--accent); color:#fff; width:100%; border:0;">Отправить вызов</button>
            </form>
        </div>
        <?php
    }
}
echo "<div style='text-align:center;'><a href='club.php?id=$id'>Назад к клубу</a></div>";
include '../system/footer.php';
?>

