<?php
require_once '../system/db.php';
include '../system/header.php';
require_once "manfunc.php"; 

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$my_id = isset($_SESSION['user_id']) ? (int)$_SESSION['user_id'] : 0;

// Проверяем права (админ или сам владелец)
// Предполагаем, что $club_id — это ID клуба текущего юзера, определенный в header.php
if ($level >= 9 || $id == $club_id) {
    
    $q = mysqli_query($db, "SELECT * FROM fman_clubs WHERE id = '$id' LIMIT 1");
    $a = mysqli_fetch_assoc($q);

    if (!$a) {
        echo "<div class='note-item'>Клуб не найден.</div>";
        include '../system/footer.php'; exit;
    }

    // Проверка на "правило 7 дней" для обычных юзеров
    // Поле u8 используется как дата вступления в должность
    if ($a['u8'] > (time() - 604800) && $rights < 7) {
        echo "<div class='note-item' style='border-left: 4px solid #e67e22; background: #fff9f0;'>
                <b>Внимание!</b><br>Запрещено увольняться из команды, в которой вы были менеджером меньше 7 дней. 
                Если у вас есть уважительная причина, напишите администрации.
              </div>";
    } else {
        if (!isset($_GET['yes'])) {
            ?>
            <div class="note-item" style="text-align: center; padding: 30px;">
                <h3 style="color: #e74c3c;">⚠️ Подтверждение увольнения</h3>
                <p>Вы уверены, что хотите покинуть пост менеджера клуба <b><?php echo htmlspecialchars($a['name']); ?></b>?<br>
                Это решение окончательное.</p>
                
                <div style="margin-top: 20px;">
                    <a href="uvol.php?id=<?php echo $id; ?>&yes=1" class="btn-land" style="background: #e74c3c; color: white; padding: 10px 25px; text-decoration: none; border-radius: 8px; font-weight: bold;">ДА, УВОЛИТЬСЯ</a>
                    <br><br>
                    <a href="club.php?id=<?php echo $id; ?>" style="color: #7f8c8d; text-decoration: none;">Нет, я остаюсь</a>
                </div>
            </div>
            <?php
        } else {
            // ФИНАЛЬНЫЙ ПРОЦЕСС УВОЛЬНЕНИЯ
            $user_to_fire = $a['user_id'];
            
            // 1. Освобождаем клуб в таблице fman_clubs
            mysqli_query($db, "UPDATE fman_clubs SET user_id = 0, u8 = 0 WHERE id = '$id'");

            // 2. Сбрасываем параметры игроков клуба
            // Сбрасываем форму, усталость и игровые навыки до базовых значений (6) или 0
            mysqli_query($db, "UPDATE fman_players SET 
                forma = 6, ust = 6, nast = 6, u = 0, vyn = 0, drib = 0, 
                pas = 0, ig = 0, otb = 0, priem = 0, f = 0, toch = 0, 
                gk = 0, ball = 0 
                WHERE team_id = '$id' AND (trans != 1 OR zarplat = 0)");

            // 3. Получаем данные уволенного менеджера для ленты новостей
            $qu = mysqli_query($db, "SELECT login FROM users WHERE id = '$user_to_fire' LIMIT 1");
            $udata = mysqli_fetch_assoc($qu);
            $manager_name = $udata['login'] ?? 'Неизвестный';

            // Формируем текст новости
            $wtext = "Менеджер клуба <a href='club.php?id=$id'>{$a['name']}</a> <a href='/users/profile.php?user=$user_to_fire'>$manager_name</a> покинул свой пост.";
            
            // Если уволил админ, добавляем информацию об этом
            if ($id != $club_id) {
                $wtext .= "<br/>Действие выполнил администратор: " . ($_SESSION['user_login'] ?? 'Admin');
            }

            // Добавляем в общие новости и новости клуба (предполагаем наличие функции newsadd)
            if (function_exists('newsadd')) {
                newsadd($wtext, 0); // Общая
                newsadd($wtext, $id); // Клубная
            }

            echo "<div class='note-item' style='border-left: 4px solid #27ae60; background: #f0fdf4; text-align: center;'>
                    <h3 style='color: #27ae60;'>Действие успешно!</h3>
                    Пост менеджера теперь вакантен.
                  </div>";
        }
    }
} else {
    echo "<div class='note-item'>У вас нет прав для выполнения этого действия.</div>";
}

echo "<div class='phdr' style='text-align:center; margin-top:20px;'>
        <a href='index.php' style='text-decoration:none; color:#3498db; font-weight:bold;'>🏠 В офис менеджера</a>
      </div>";

include '../system/footer.php';
?>

