<?php
require_once '../system/db.php';
include '../system/header.php';

// 1. Проверка авторизации
$my_id = isset($_SESSION['user_id']) ? (int)$_SESSION['user_id'] : 0;

if (!$my_id) {
    echo "<div class='note-item' style='border-left:4px solid #e74c3c;'>Чтобы получить команду, необходимо авторизоваться на сайте.</div>";
    include '../system/footer.php';
    exit;
}

// 2. Данные игрока
$res_user = mysqli_query($db, "SELECT login, level FROM users WHERE id = $my_id");
$user_data = mysqli_fetch_assoc($res_user);
$my_login = $user_data['login'];
$rights = $user_data['level'];
$realtime = time();

$act = isset($_GET['act']) ? mysqli_real_escape_string($db, $_GET['act']) : '';
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// 3. Проверка наличия клуба (используем вашу структуру)
$check_club = mysqli_query($db, "SELECT id FROM fman_clubs WHERE user_id = '$my_id' LIMIT 1");
if (mysqli_num_rows($check_club) > 0) {
    echo "<div class='note-item' style='border-left:4px solid #3498db;'>У вас уже есть клуб!</div>";
    echo "<div class='menu-item' style='text-align:center;'><a href='index.php'>В офис</a></div>";
    include '../system/footer.php';
    exit;
}

echo "<style>
    .club-selector { display: grid; grid-template-columns: repeat(auto-fill, minmax(160px, 1fr)); gap: 10px; padding: 10px; }
    .club-card { background: #fff; border-radius: 12px; padding: 15px; text-align: center; box-shadow: 0 2px 8px rgba(0,0,0,0.05); border: 1px solid #f0f0f0; text-decoration: none; color: #333; }
    .confirm-box { background: #fff; padding: 25px; border-radius: 15px; text-align: center; margin: 15px; box-shadow: 0 4px 15px rgba(0,0,0,0.1); }
    .btn-action { display: inline-block; padding: 10px 20px; border-radius: 20px; text-decoration: none; font-weight: bold; margin: 5px; }
    .btn-yes { background: #27ae60; color: #fff; }
    .btn-no { background: #95a5a6; color: #fff; }
</style>";

switch ($act) {
    default:
        echo "<div class='card-title' style='padding:10px;'>Выберите свободный клуб</div>";
        // user_id = 0 означает, что клуб свободен
        $q = mysqli_query($db, "SELECT id, name, city FROM fman_clubs WHERE user_id = 0 ORDER BY name ASC");
        
        if (mysqli_num_rows($q) == 0) {
            echo "<div class='note-item'>Свободных команд нет.</div>";
        } else {
            echo "<div class='club-selector'>";
            while ($a = mysqli_fetch_assoc($q)) {
                echo "<a href='zayv.php?act=pod&id=" . $a['id'] . "' class='club-card'>
                        <b>" . htmlspecialchars($a['name']) . "</b><br>
                        <small style='color:gray;'>" . htmlspecialchars($a['city']) . "</small><br>
                        <small style='color:#3498db;'>Взять управление</small>
                      </a>";
            }
            echo "</div>";
        }
        break;

    case 'pod':
        $q = mysqli_query($db, "SELECT id, name FROM fman_clubs WHERE id = '$id' AND user_id = 0 LIMIT 1");
        $a = mysqli_fetch_assoc($q);

        if (!$a) {
            echo "<div class='note-item'>Клуб не найден или уже занят.</div>";
        } else {
            if (!isset($_GET['yes'])) {
                echo "<div class='confirm-box'>
                        <h3>Подтверждение</h3>
                        Вы уверены, что хотите возглавить <b>" . htmlspecialchars($a['name']) . "</b>?<br><br>
                        <a href='zayv.php?act=pod&id=$id&yes=yes' class='btn-action btn-yes'>Да!</a>
                        <a href='zayv.php' class='btn-action btn-no'>Отмена</a>
                      </div>";
            } else {
                // ОБНОВЛЕНИЕ ПО ВАШЕЙ ТАБЛИЦЕ (убраны u8, u9)
                mysqli_query($db, "UPDATE fman_clubs SET user_id = '$my_id' WHERE id = '$id'");
                
                // СИНХРОНИЗАЦИЯ С ТАБЛИЦЕЙ USERS (поле team_id со скриншота №4)
                mysqli_query($db, "UPDATE users SET team_id = '$id' WHERE id = '$my_id'");
                
                // Запись в новости
                $news_text = mysqli_real_escape_string($db, "Новым менеджером клуба " . $a['name'] . " стал " . $my_login);
                mysqli_query($db, "INSERT INTO fman_news (time, club_id, text) VALUES ('$realtime', '$id', '$news_text')");

                echo "<div class='confirm-box'>
                        <h3>🎉 Поздравляем!</h3>
                        Вы назначены тренером <b>" . htmlspecialchars($a['name']) . "</b>!<br><br>
                        <a href='index.php' class='btn-action btn-yes'>В кабинет</a>
                      </div>";
            }
        }
        break;
}

echo "<div style='text-align:center; margin-top:20px;'><a href='index.php' style='color:#7f8c8d;'>⬅ Назад</a></div>";
include '../system/footer.php';
?>

