<?php 
// Запуск сессии для работы авторизации
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

require_once 'db.php';

// Устанавливаем московское время
date_default_timezone_set('Europe/Moscow');

/**
 * Глобальная функция фильтрации данных
 */
if (!function_exists('clean')) {
    function clean($str) {
        global $db;
        if (!$str) return '';
        return mysqli_real_escape_string($db, trim(htmlspecialchars($str)));
    }
}

// Если пользователь авторизован
if(isset($_SESSION['user_id'])) {
    $user_id = intval($_SESSION['user_id']);
    
    $db_date = date("Y-m-d H:i:s");
    $unix_time = time();
    mysqli_query($db, "UPDATE users SET last_visit = '$db_date', lastdate = '$unix_time' WHERE id = '$user_id'");
    
    $res = mysqli_query($db, "SELECT * FROM users WHERE id = '$user_id' LIMIT 1");
    $user_data = mysqli_fetch_assoc($res);
    
    if (!$user_data) {
        session_destroy();
        header("Location: /");
        exit;
    }
}

// Логика красивой даты
$months = [
    1 => 'января', 'февраля', 'марта', 'апреля', 'мая', 'июня',
    'июля', 'августа', 'сентября', 'октября', 'ноября', 'декабря'
];
$current_date_text = date('j') . ' ' . $months[date('n')] . ' ' . date('Y');
$current_time_text = date('H:i');
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/theme/style.css">
    <title>GreenCMS</title>
    <style>
        /* Стили для блока времени */
        .msk-time-bar {
            background: #f8f9fa;
            border-bottom: 1px solid #eee;
            padding: 8px 15px;
            display: flex;
            justify-content: center;
            align-items: center;
            font-family: 'Segoe UI', Roboto, sans-serif;
            font-size: 13px;
            color: #555;
        }
        .msk-time-box {
            display: flex;
            align-items: center;
            gap: 10px;
            background: #fff;
            padding: 4px 12px;
            border-radius: 20px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.05);
            border: 1px solid #e0e0e0;
        }
        .time-icon { color: #27ae60; font-weight: bold; }
        .time-value { font-weight: 700; color: #2c3e50; }
        .time-sep { color: #ccc; }
    </style>
</head>
<body>

<header>
    <div class="logo">GREEN<span>CMS</span></div>
    <nav class="mobile-menu">
        <a href="/">🏠 Главная</a>
        <a href="/system/online.php">🌐 Онлайн</a>
        <?php if(isset($_SESSION['user_id'])): ?>
            <a href="/users/profile.php">👤 <?php echo htmlspecialchars($user_data['login']); ?></a>
            <?php if(isset($user_data['level']) && $user_data['level'] >= 5): ?>
                <a href="/admin/index.php" style="color:#e74c3c;">🛠 Панель</a>
            <?php endif; ?>
            <a href="/users/logout.php">🚪 Выход</a>
        <?php else: ?>
            <a href="/users/login.php">🔑 Вход</a>
            <a href="/users/reg.php">📝 Регистрация</a>
        <?php endif; ?>
    </nav>
</header>

<div class="msk-time-bar">
    <div class="msk-time-box">
        <span class="time-icon">📅</span>
        <span><?php echo $current_date_text; ?></span>
        <span class="time-sep">|</span>
        <span class="time-icon">🕒</span>
        <span class="time-value"><?php echo $current_time_text; ?></span>
        <span style="font-size: 10px; color: #999; margin-left: -5px;">МСК</span>
    </div>
</div>

<main>
