<?php
require_once '../system/db.php';
include '../system/header.php';

$uid = isset($_GET['id']) ? (int)$_GET['id'] : ($_SESSION['user_id'] ?? 0);

if (!$uid) { header("Location: /users/login.php"); exit; }

$res = mysqli_query($db, "SELECT * FROM users WHERE id = $uid");
$user = mysqli_fetch_assoc($res);

if (!$user) { echo "Пользователь не найден."; include '../system/footer.php'; exit; }

$is_my = (isset($_SESSION['user_id']) && $_SESSION['user_id'] == $user['id']);
?>

<div class="profile-card" style="background: white; padding: 20px; border-radius: 15px; text-align: center;">
    <div style="font-size: 50px;">👤</div>
    <h2><?php echo $user['login']; ?></h2>
    <p>Уровень доступа: <b><?php echo $user['level']; ?></b></p>
    <p>Был в сети: <br><small><?php echo $user['last_visit']; ?></small></p>

    <?php if($is_my): ?>
        <p style="color: green;">Это ваш профиль</p>
        <a href="/users/settings.php" class="btn-more">Настройки</a>
    <?php else: ?>
        <a href="/users/pm.php?to=<?php echo $user['id']; ?>" class="btn-more">Написать сообщение</a>
    <?php endif; ?>

    <?php if(isset($_SESSION['level']) && $_SESSION['level'] >= 9 && !$is_my): ?>
        <div style="margin-top:20px; border: 2px dashed red; padding: 10px;">
            <p style="color:red; font-weight:bold;">Управление админом:</p>
            <a href="/admin/index.php?delete=<?php echo $user['id']; ?>" class="del-link">Удалить аккаунт</a><br><br>
            <a href="/admin/index.php?user_id=<?php echo $user['id']; ?>&set_lvl=5">Сделать модером</a>
        </div>
    <?php endif; ?>
</div>

<?php include '../system/footer.php'; ?>
